#!/bin/bash
set -e

echo "Starting maillists services..."
ENV_TYPE=$([ -z "$YENV_TYPE" ] && echo testing || echo "$YENV_TYPE")

ln -fs /etc/distributed-flock.$ENV_TYPE.json /etc/distributed-flock.json
cp /etc/yandex-tools-maillists-maintenance.$ENV_TYPE.cron.d /etc/cron.d/yandex-tools-maillists-maintenance
chmod 644 /etc/cron.d/yandex-tools-maillists-maintenance

mkdir -p /var/log/yandex/tools-maillists/
mkdir -p /var/log/yandex/tools-maillists/updates
mkdir -p /var/log/yandex/tools-maillists/office_subscriber
mkdir -p /var/log/yandex/tools-maillists/office_subscriber/weekly
mkdir -p /var/log/yandex/tools-maillists/staff_subscriber
mkdir -p /var/log/yandex/tools-maillists/dismissed_unsubscriber
chown -R www-data:www-data /var/log/yandex/tools-maillists
chmod -R og+w /var/log/yandex/tools-maillists

chmod 0755 /var/log/yandex/tools-maillists/
chmod 0644 /var/log/yandex/tools-maillists/* || true
chmod 0644 /etc/yandex/tools-maillists/settings.py || true

mkdir -p /var/spool/smailik/maillists
chown -R www-data:www-data /var/spool/smailik/maillists
chmod -R og+w /var/spool/smailik/maillists

mkdir -p /var/lock

mkdir -p /var/spool/ml
chown -R www-data:www-data /var/spool/ml
chmod -R og+w /var/spool/ml

touch /tmp/zkflock.log
chmod a+rw /tmp/zkflock.log

/usr/bin/env | grep -e "^QLOUD_" -e "^YENV_" |  # Getting all relevant environment variables
cut -d "=" -f 1 |  # Splitting by "=" to get variable names only
while read -r var  # Iterating over variable names
do
    echo export $var=`printf "%q" "${!var}"`  # Forming export command with variable name and escaped variable value
done > /.env  # Writing everything to file

echo export PYTHONPATH="/app/:/app/maillists" >> /.env
echo $YENV_TYPE > /etc/yandex/environment.type
echo $YENV_NAME > /etc/yandex/environment.name

echo "RUN $@"
exec "$@"
