#!/usr/lib/yandex/maillists/bin/python
# -*- coding: utf-8 -*-
import MySQLdb
from django.db import connections

from maillists import settings

OK = 0
WARN = 1
CRIT = 2

WARN_SECONDS = 60
CRIT_SECONDS = 180


def dictfetchone(cursor):
    return dict(zip([col[0] for col in cursor.description], cursor.fetchone() or []))


def check_replication():
    result = []
    status = OK
    slaves = getattr(settings, 'DATABASE_SLAVES', [])
    for db_alias in getattr(settings, 'DATABASES', {}):
        config = settings.DATABASES[db_alias]
        try:
            db = MySQLdb.connect(
                host=config['HOST'],
                user=config['USER'],
                passwd=config['PASSWORD'],
                db=config['NAME'],
                charset='utf8',
                connect_timeout=3,
            )
        except MySQLdb.OperationalError:
            err_msg = 'host is offline'
            print '%s; %s: %s' % (WARN, err_msg, config['HOST'])
            return
        cursor = db.cursor()
        is_master = not bool(cursor.execute('SHOW SLAVE STATUS;'))
        seconds = dictfetchone(cursor).get('Seconds_Behind_Master')

        expected_master = db_alias not in slaves
        if is_master != expected_master:
            if is_master:
                err_msg = 'is a master, but expected to be a slave'
            else:
                err_msg = 'is a slave, but expected to be a master'
            print '%s; db "%s" %s' % (CRIT, db_alias, err_msg)
            return

        if not is_master:
            result.append((db_alias, seconds))
            if seconds is None or seconds >= CRIT_SECONDS:
                status = max(status, CRIT)
            elif seconds >= WARN_SECONDS:
                status = max(status, WARN)
    print '%s;' % status, ', '.join(['%s: %s' % (slave, lag) for slave, lag in result])


if __name__ == '__main__':
    check_replication()
