#!/usr/lib/yandex/maillists/bin/python
# -*- coding: UTF-8 -*-

import subprocess
import sys
import time
import re
import socket
import os
import MySQLdb
import datetime
from collections import Counter

from  maillists import settings

DATABASES = settings.DATABASES

master = DATABASES['default']['HOST']
user = DATABASES['default']['USER']
password = DATABASES['default']['PASSWORD']
dbname = DATABASES['default']['NAME']


status = 2
info = "Can't connect to any db"
errors = ""


def result(status, info):
    print str(status) + ";" + info
    exit()

hosts = [master]


# По очереди подключаемся ко всем хостам пока не будет успеха:
for host in hosts:
    try:
        db = MySQLdb.connect(host=host, user=user, passwd=password,
                             db=dbname, charset='utf8', connect_timeout=10)
        cursor = db.cursor()
        # Фейлы за час:
        sql = "SELECT name  FROM ml_operationlog WHERE status='FAILURE' AND unix_timestamp(current_timestamp) - unix_timestamp(started) < 3600"
        cursor.execute(sql)

        row = [item[0] for item in cursor.fetchall()]
        info = ""
        FAILS = dict(Counter(row))

        # Формируем строку с ошибками:
        for item in FAILS:
            info = info + re.sub(".*\.", " ", item) + \
                ": " + str(FAILS.get(item)) + ";"

        status = 0
        if sum(FAILS.values()) > 15:
            status = 1
        if sum(FAILS.values()) > 50:
            status = 2
        break
    except:
        pass

result(status, info)
