#!/usr/bin/python
# -*- coding: utf-8 -*-

import re
import subprocess
from yamail.graphite import *
from yamail.timetail import *

log = timetail('/var/log/nginx/access.log')

def getUrlPath(line):
    url_path = line.split('"')[1].split()[1].split('?')[0]
    url_path = re.sub('/', '_', url_path)
    url_path = re.sub('\.', '_', url_path)
    url_path = url_path[1:]
    # Удадаляем uid из url_path:
    url_path = "_".join([i if not i.isdigit() else '' for i in url_path.split('_')])
    # Сокращаем пути статики:
    url_path = re.sub('.*lego.*', 'lego', url_path)
    url_path = re.sub('.*css.*', 'css', url_path)
    url_path = re.sub('.*svg.*', 'svg', url_path)
    url_path = re.sub('.*png.*', 'png', url_path)
    url_path = re.sub('.*jpg.*', 'jpg', url_path)
    url_path = re.sub('.*gif.*', 'gif', url_path)
    return url_path

def getHttpCode(line):
    code = line.split('"')[2]
    return int(code)

def getRequestTime(line):
    request_time = float(line.split()[-3])
    timings = [0.1, 0.25, 0.5, 1, 3, 5, 10]
    for timing in timings:
        if request_time < timing:
            return str(int(timing * 1000)) + 'ms'
    return 'inf'

requests = {}
for line in log:

    url_path = getUrlPath(line)
    code = getHttpCode(line)
    request_time = getRequestTime(line)
    if requests.get(url_path) is None:
        requests[url_path] = {'codes': {}, 'request_times': {}}
    requests[url_path]['codes'][code] = requests.get(
        url_path).get('codes').get(code, 0) + 1
    requests[url_path]['request_times'][request_time] = requests.get(
        url_path).get('request_times').get(request_time, 0) + 1

for url_path in requests:
    codes = requests[url_path]['codes']
    request_times = requests[url_path]['request_times']
    for code in codes:
        value = codes[code]
        print "%s.web.codes.%s.%s %s %s" % (qloud_prefix, url_path, code, value, timestamp)
    for request_time in request_times:
        value = request_times[request_time]
        print "%s.web.timings.%s.%s %s %s" % (qloud_prefix, url_path, request_time, value, timestamp)
