# coding: utf-8
import os
import logging
import warnings


DRY_RUN = True

db_defaults = {
    'ENGINE': 'django.db.backends.mysql',
    'NAME': 'ml',
    'USER': 'ml-user',
    'PASSWORD': 'ml-password',
    'OPTIONS': {
        'charset': 'utf8mb4',
        'connect_timeout': 2,
        'init_command': 'SET SESSION innodb_lock_wait_timeout = 200;'
    },
}

DATABASES = {
    'default': dict(db_defaults,  HOST='mysql', ATOMIC_REQUESTS=True),
    'localhost':  dict(db_defaults,  HOST='localhost'),
}

TVM_PUBLIC_KEYS = (
    '885:1495790481:MIGDAoGAfUyVSTYat7uAe0X-2h6aYtgbRk9cGkJqPnruZexX5EMSkIXQdt-MGF_CDs7M_jUNxv5sxQEUE8zAJ-vLeWjcMOViPaCGhpDpdZRecLbHEL9IYlMqC7GP3pQLv_K6kIa0F-ynkto6bxmQYu-p4kpC5365tCEG4uigZCBwLsueNLU\n'
    '241:1487683232:MIGDAoGAfdsaQ1NLfkgGBQOqYfiF97klHtcUgYP-UGSguihfmY2lNpt1mjcF6vGRkMI4QY_E7P7kZlJ4RTzpVXkyy3wSzs1zwb1WPDS5aoqE1Nfs-uuOL0IQ3CxvwWV4aEJ8JV7nKFUyLsVtHExMLS8wZec_sJbPcCln_P96hKWEFnzIPdU\n'
    '284:1490277726:MIGEAoGBAN_tRrCJiPnF0nx1elQeVU-PrFFshDOtrs1gmVheJRHV0HhtHuat_LFoLy5EjG4jzH2EYdM4W9B9_s3ftnec6uQXvf3g4icx0mvLM6y-eLZJAI0b7tpMD_yn2XaQgGdMKdSTkErZHKpjH_vQp9bKEVZOmdUQ5R7D13HNbsd8SxDt\n'
    '1250:1501262938:MIGEAoGBAKssoO_3n5-cuVyJbmuXOeDK2Caye_orjlsO3xMt-BT09L3q_OrkcoMYLCN5iXGY6zDd_bYjBFs-UXbod6TQzK-52XZ3X_Nl0VodjQDmqTc25Mz66UyaQmH_YwbZtcbKF2zHD5LPKtl_YrGjtPG-E0Mrh3ck5RsfXZtUMPGdQcPF\n'
    '1028:1499689981:MIGEAoGBANOa-JctY9Qk9pKJwCsC9Kl-sPicmQzKUh82j9rStgg7xfAw-ZqD3NTeVBn6-1mYUjJUqAl6BVYarV4zgk8bCkqYbd7vU-TtFFPVR_X2rvgQatf7HSjtD-ZGxDijr4y46hHkopUh0cS4Z8FMpUBR-tfF85UxfJViVke_rVjLGHE1\n'
    '1045:1499771475:MIGEAoGBANqwAf1XknL4Zvk3_2o450oUH9G-GNfAyjhx_lXhM0SB-TcR432J618mJB56Kv-g8ORwRdwzjYYzf4ua6ocuzSEDp1S76nPoe6vNBNEzs69yrZh5MoLyBrp-F_9hDLe7EHY6PkabTa-EAt33CR2Ynhx0woNbvE0A3ASFJ_9GB1T1'
)

TVM_CLIENTS = [177, 203, 154, 2000053, 2000099, 2000058]
YWMI_API_URL = "https://meta-test.mail.yandex.net:443"
YWMI_TVM_ID = 2000501
MESSAGE_BODY_URL = 'https://mbody-test.mail.yandex.net:443'
MESSAGE_BODY_TVM_ID = 2000585
PG_MIGRATION_STATE = 'pg'

YORK_API_URL = "https://yorkcorp-test.mail.yandex.net"
YORK_TVM_ID = 2001199

TVM_USE = True
YWMI_API_URL = "https://meta-test.mail.yandex.net:443"
YWMI_TVM_ID = 2000501

CELERY_ALWAYS_EAGER = True
CELERY_EAGER_PROPAGATES_EXCEPTIONS = True
CELERY_MONGODB_BACKEND_SETTINGS = {"database": "maillists"}
BROKER_URL = 'mongodb://mongo'
CELERY_RESULT_BACKEND = BROKER_URL
CELERY_IMPORTS = ('mlcore.tasks',)


warnings.filterwarnings('ignore', category=UserWarning, module=r'^pymongo\.connection$')

ETC_PATH = '/etc/yandex/tools-maillists'
VAR_PATH = '/app/maillists'
LOG_PATH = '/var/log/yandex/tools-maillists'
LOCK_PATH = '/var/lock/yandex-tools-maillists'

LOG_LEVEL = logging.DEBUG
os.environ['REQUESTS_CA_BUNDLE'] = '/etc/ssl/certs/ca-certificates.crt'
MEDIA_ROOT = os.path.join(VAR_PATH, 'htdocs')

TVM2_CLIENT_ID = 0
TVM2_SECRET = ''
