#!/usr/bin/env python
# coding: utf-8

import os
import sys
from itertools import izip, repeat, count
import time

import sh
import yenv
from opster import command

def filename(number, *args):
    name = '.'.join(args)
    return "%02d-%s" % (number, name)

@command(usage="[path/to/manage.py] [path/to/dump/dir] [--dry-run]")
def main(manage="./src/maillists/manage.py",
         dump_dir=os.path.join(__file__, 'dump'),
         dry_run=('', False, u"Only prints commands")):
    u""" Выгружает данные для дампа """

    if not os.path.exists(manage):
        print "Can't find manage.py %s" % manage

    if not os.path.exists(dump_dir):
        try:
            os.mkdir(dump_dir)
        except OSError, exc:
            print exc
            return 1

    managepy = sh.Command(manage)
    dump = managepy.bake('mldumpdata', indent=2, database='default')

    apps = {'django': ['auth', 'admin', 'contenttypes', 'sessions', 'messages',
                       'humanize'],
            'intranet': ['django_intranet_stuff', 'django_api_auth'],
            'mlcore': ['ml', 'permissions', 'stats', 'sms_filter', 'yandex_team',
                       'cmail', 'freshness'],
    }

    excludes = ['stats.AccessManagementLog', 'ml.Autosubscription',
                'ml.BackendContext', 'cmail.CmailBackendContext',
                'stats.EmailActivity', 'ml.EmailSubscriber',
                'permissions.GroupPermission',
                'stats.GroupPermissionLog', 'permissions.ListPermission',
                'ml.MailList', 'ml.Owner', 'ml.PendingSubscribeOperation',
                'sms_filter.SMSMailList', 'stats.SubscribeActivity',
                'stats.SubscribeOperationLog', 'ml.Subscribers',
                'permissions.SubscriptionRequest', 'freshness.FactorValue',
                'yandex_team.YandexTeamBackendContext',
    ]

    ignore = ['django_intranet_stuff.LastUpdate', 'auth.Permission', 'auth.Group',
              'django_intranet_stuff.Log']


    exclude_params = ["%s=%s" % item for item in izip(repeat('--exclude'),
                                                      excludes + ignore)]

    # добавляем в продакшене freshness сломанные в тестовой базе
    if yenv.type != 'production':
        del excludes[excludes.index('freshness.FactorValue')]
        exclude_params.append("--exclude=freshness.FactorValue")

    wait = []
    for i, (name, app) in enumerate(apps.iteritems(), 1):
        d =  dump.bake(*(exclude_params + app))
        print "Started: ", d.ran
        if not dry_run:
            d = d(_bg=True, _err=sys.stderr,
                  _out=os.path.join(dump_dir, filename(i, name, 'json')))
        wait.append(d)

    for i, model in izip(count(i+1), excludes):
        d = dump.bake(model)
        print "Started: ", d.ran
        if not dry_run:
            d = d(_bg=True, _err=sys.stderr,
                  _out=os.path.join(dump_dir, filename(i, model, 'json')))
        wait.append(d)

    if dry_run:
        return 0

    alive = len(wait)
    finished = set()
    while alive:
        for proc in wait:
            if not proc.process.alive and proc not in finished:
                print "Finished: ", proc.ran
                alive -= 1
                finished.add(proc)
        time.sleep(1)

    # на всякий случай
    print "Waiting..."
    for proc in wait:
        proc.wait()

    return 0


if __name__ == '__main__':
    sys.exit(main.command())
