# encoding: utf-8
from fabric.api import run, env, local, hosts, get

try:
    from fabric.api import execute
except ImportError:
    # hack for old fabric
    execute = lambda f: f()

import os


def _set_remote_dir():
    project = os.path.split(env.real_fabfile)[0].split('/')[-1]
    try:
        env.remote_dir = os.path.join(env.remote_workspace,
                project)
    except AttributeError:
        raise RuntimeError('Add "remote_workspace" setting to ~/.fabricrc')


def _set_local_dir():
    env.local_dir = os.path.split(env.real_fabfile)[0]


def _set_is_local():
    env.is_local = not os.path.exists(env.remote_dir)


def _set_path():
    _set_local_dir()
    _set_remote_dir()
    _set_is_local()


def rebuild_static():
    run('cd %(remote_dir)s/htdocs/ && make YCSSJS_PARAMS=--minimize=no rebuild yjs ycss' % env)


def run_tests():
    run('cd %(remote_dir)s/src/maillists/ && ./test_all.py' % env)


def default():
    execute(rebuild_static)
    execute(run_tests)


@hosts(['ml02e.tools.yandex.net'])
def dl_cmaillog():
    import re, gzip
    import simplejson as json

    run("find /var/log/yandex/tools-maillists/cmail/ -iname \"*.txt.gz\" | sort | tail -n 2 | xargs -I{} cp {} /tmp/")
    local('mkdir -p ./tmp')
    get('/tmp/*.txt.gz', './tmp')
    run("rm /tmp/*.txt.gz")

    files = local('ls ./tmp/20*.gz', capture=True).split('\n')

    for filename in files:
        with gzip.open(filename) as fp:
            obj = json.load(fp, encoding='koi8-r')

        with open(re.sub(r'\d+_get_maillists_', '', filename).replace('.txt.gz', '_answer.json'), 'w') as fp:
            json.dump([["group_name", [obj['body']]]], fp, indent=4)

    local('rm ./tmp/*.gz')
_set_path()
