(function($, Lego) {

Lego.block['b-access-list'] = function(params) {
    var block = this,

        // Объекты для хранения групп и пользоватлей
        groups = {},
        users = {},

        permitted_groups = {},
        permitted_users = {},

        // Объект для подсчета разного вида групп и пользоватлей. Нужен для скрытия если групп опрделенного типа нет
        total = {},

        data = {},

        userItems = $('.b-access-list__item_type_user', block).not('.b-access-list__js-sample-user'),
        clearItem =  $('.b-access-list__clear', block),

        newBlock = $('.b-access-list__add', block),
        newSwither = $('.b-access-list__add__type', newBlock),
        permTypeSwitcher = $('.b-access-list__add__permission'),
        newInputs = $('.b-access-list__add__input', newBlock),
        newActiveInput = null,
        newSubmit = $('.b-access-list__add__submit', newBlock),
        newWarn = $('.b-access-list__add__error', newBlock),
        newSamples = $('.b-access-list__add__sample', newBlock),
        newSamplesLinks = $('.b-pseudo-link', newSamples),

        forceAutocompleteUrl = params.forceAutocompleteUrl,

        submitPermissions = $('#submitAccess'),

        pendingAccessList = $('.b-access-list__list_wrapper',block),
        userSample = $('.b-access-list__js-sample-user',block).removeClass('b-access-list__js-sample-user'),
        groupSample = $('.b-access-list__js-sample-group',block).removeClass('b-access-list__js-sample-group'),
        membersSample = $('.b-access-list__js-sample-members',block).removeClass('b-access-list__js-sample-members'),
        memberSample = $('.b-access-list__js-sample-member',block).removeClass('b-access-list__js-sample-member'),

        headers = {
            departments: $('.b-access-list__item_header_dep', block),
            services: $('.b-access-list__item_header_ser', block),
            intra: $('.b-access-list__item_header_grp', block),
            user: $('.b-access-list__item_header_usr', block)
        },

        mode = newSwither.val(),

        i18n = params.i18n || {};

    init();
    activateMode(mode);

    // Переключение режимов добавления группы/пользователя

    newSwither.change(function(){
      activateMode(this.value,true);
    });


    // Клики по примерам

    newSamplesLinks.click(function(){
        newActiveInput.val($(this).text());
        newActiveInput.focus();
        newActiveInput.trigger('keydown');
    })


    // Вывод сообщения о ненайденноcти групп и сотрудников в полях автокомплитов

    newInputs.keypress(function(e){
        if (e.keyCode == 13 && newWarn.hasClass("g-hidden") && !newWarn.val()) {
            e.stopPropagation();
            e.preventDefault();

            newSubmit.trigger('click');
        } else if (e.keyCode == 13) {
            e.stopPropagation();
            e.preventDefault();
        } else {
            clearWarning();
        }
    })

    submitPermissions.click(function() {
        $.ajax({
            type: "POST",
            data: JSON.stringify(data),
            success: function(r) {
                if (r.status == 'error')
                    putWarning(r.message);
                else
                    window.location=window.location;
            }
        });
    });

    newSubmit.click(function() {
        $.ajax({
            url: forceAutocompleteUrl,
            dataType: "json",
            type: "GET",
            data: {"user_or_group": newActiveInput.val(), "type": mode},
            success: function(r) {
                if (r.error) {
                    var warn = r.error +"_"+ mode;
                    putWarning(warn);
                } else if (r) {
                    clearWarning();
                    if (mode == "user") {
                        addUserToList(r);
                    } else {
                        addGroupToList(r, mode);
                    }
                }
            },
            error: function() {
                loaderImg.after('<div class="b-warning">'+ i18n.LoadingFailedTryAgainLater +'</div>');
            }
        });
    });

    clearItem.click(function() {
        $('.b-access-list__delete',block).trigger('click');
    });

    function putWarning(msg) {
        newWarn.removeClass('g-hidden');
        newWarn.text(i18n[msg] ? i18n[msg] : i18n["LookupCommonError"]);
    };

    function clearWarning() {
        newWarn.addClass('g-hidden');
        newWarn.val("");
    };

    function init() {
        // Иницаилизация уже добавленных пользователей

        for (var i in params.users) {
            permitted_users[params.users[i].login] = params.users[i];
            /*usersHidden.val(usersHidden.val() +","+ params.users[i].id);

            if (total.user) {
                total.user++;
            } else {
                total.user = 1;
            }*/
        }

        userItems.each(function() {
            assignUserHandlers($(this));
            headers.user.removeClass('g-hidden');
        });

        // Иницаилизация уже добавленных групп
        for (var i in params.groups.departments) {
            addGroupToBuffer(permitted_groups, params.groups.departments[i], 'already_permitted');
        }
        for (var i in params.groups.services) {
            addGroupToBuffer(permitted_groups, params.groups.services[i], 'already_permitted');
        }
        for (var i in params.groups.intra) {
            addGroupToBuffer(permitted_groups, params.groups.intra[i], 'already_permitted');
        }

        // Создаем поля для разных автокомплитов

        $('option', newSwither).each(function(i,el){
            var name = el.value,
                node = newInputs.clone(),
                modes = [];

            modes.push(name);
            node.attr('name',name);

            if (mode != name) {
                node.addClass('g-hidden');
            } else {
                newActiveInput = node;
            }

            newInputs.after(node);

            if (!params.internalGroups) {
                switch (name) {
                    case 'departments':
                    case 'services':
                    case 'intra':
                        node.groupsAutocomplete({result: function(d){addGroupToList(d,name)}, type: name});
                        break;
                    case 'user':
                        node.staffAutocomplete({result: addUserToList});
                        break;
                }
            } else {
                switch (name) {
                    case 'groups':
                        node.autocomplete(params.internalGroups, {
                            minChars: 0,
                            selectFirst: false,
                            max: 20
                        });
                        break;
                    case 'user':

                        break;
                }
            }
        })

        newInputs.remove();
        newInputs = $('.b-access-list__add__input', newBlock);

        // Сохраняем в инпутах их начальные значения для проверки перед уходом со страницы
        /*groupsHidden[0].startValue = groupsHidden.val();
        usersHidden[0].startValue = usersHidden.val();
        */
    }


    // Функция переключения режимов автокомплита
    function activateMode(m, focus) {
        mode = m;
        newActiveInput = newInputs.filter('[name=' + mode + ']');

        newInputs.val('');
        newInputs.addClass('g-hidden');

        newActiveInput.removeClass('g-hidden');
        if (focus) {
            newActiveInput.focus();
        }

        newSamples.addClass('g-hidden');
        newSamples.filter('.b-access-list__add__sample_type_' + mode).removeClass('g-hidden');
    }


    // Функции добавления пользователя и группы в списки

    function makeUserBlock(user, template_block) {

        var loginField = user.login_ld ? 'login_ld' : 'login',
            newUserItem = template_block.clone(),
            htmlContent = newUserItem.html(),
            fullName = [user.last_name, user.first_name].join(' ').trim(),
            newHtmlContent = sprintf(htmlContent,
                user[loginField],
                fullName[0],
                fullName.slice(1)
                );
        newUserItem.html(newHtmlContent);
        $(".auto-person-card-fixed", newUserItem).removeClass('auto-person-card-fixed');
        return newUserItem

    }

    function addUserToList(user) {
        var permission = permTypeSwitcher.val();

        if (newActiveInput) newActiveInput.val('');

        var loginField = user.login_ld ? 'login_ld' : 'login',
            login = user[loginField];

        if (!login) {
           putWarning("");
           return;
        } else if (data[login]) {
           putWarning("user_already_exists");
           return;
        }

        var newUserItem = makeUserBlock(user, userSample);

        users[login] = user;
        data[login] = {'permission': permission, 'type': 'user'};
        newUserItem[0].onclick = function() {return {"login": login}};

        headers.user.removeClass('g-hidden');
        headers.user.after(newUserItem);

        if (total.user) {
            total.user++;
        } else {
            total.user = 1;
        }

        assignUserHandlers(newUserItem);
        showClearItem();

        newUserItem.removeClass('g-hidden').css('opacity', 0).animate({opacity: [1]});
        clearWarning();
        newWarn.val("1");
        if (document.PersonCard) {
            document.PersonCard.auto();
        }
    }

    function addGroupToBuffer(buffer, group, type) {

        buffer[group.url] = group;
        if (total[type]) {
            total[type]++;
        } else {
            total[type] = 1;
        }
        return true;
    }

    function addGroupToList(group, type) {
        var permission = permTypeSwitcher.val();
        if (newActiveInput) newActiveInput.val('');

        if (!group.url) {
           putWarning("");
           return;
        } else if (data[group.url]) {
           putWarning("group_already_exists");
           return;
        }

        addGroupToBuffer(groups, group, type);

        var newUserGroup = groupSample.clone(),
            plusIco = $('.b-access-list__group__members-trigger .b-icon', newUserGroup),
            noteElem = $('.b-access-list__group__note', newUserGroup),
            triggerElem = $('.b-access-list__group__members-trigger', newUserGroup),
            note = "",
            typeHeader = headers[type];

        typeHeader.removeClass('g-hidden');
        newUserGroup.removeClass('g-hidden');
        newUserGroup.data('type',type);

        data[group.url] = {'permission': permission, 'type': 'group'};
        plusIco.after(group.name);
        noteElem.text(note);
        var elem = triggerElem.get(0);
        elem.onclick = function() {return {"url": group.url}};
        typeHeader.after(newUserGroup);

        assignGroupHandlers(newUserGroup);
        showClearItem();

        newUserGroup.css('opacity', 0).animate({opacity: [1]});

        clearWarning();
        newWarn.val("1");

    }


    // Функции для навешивания событий на новые элементы списка групп или пользователей

    function assignUserHandlers(userItemNode) {
        $('.b-access-list__delete', userItemNode).click(function() {
            userItemNode.remove();
            var login = userItemNode[0].onclick().login;
            users[login] = null;
            delete data[login];

            total.user--;
            if (!total.user) {
                headers.user.addClass('g-hidden');
            }

            checkAndHideClearItem();
        });
    }

    function assignGroupHandlers(groupItemNode) {
        var trigger = $('.b-access-list__group__members-trigger', groupItemNode),
            deleteButton = $('.b-access-list__delete', groupItemNode),
            loaderImg = $('.b-access-list__group__loader', groupItemNode),
            membersContainer = null;

        var id = trigger.length ? trigger.get(0).onclick().url :0;//onclick().id : 0;

        trigger.toggle(
            function(){
                if (membersContainer) {
                    membersContainer.removeClass('g-hidden');
                } else {
                    loaderImg.removeClass('g-hidden');
                    $('.b-warning', groupItemNode).remove();

                    $.ajax({
                        url: '//center.yandex-team.ru/api/v1/groups/'+ id +'/all_members.jsonp',
                        dataType: "jsonp",
                        type: 'GET',
                        success: function(data) {

                            membersContainer = membersSample.clone().removeClass('g-hidden');
                            membersContainer.empty();

                            data.sort(function(a, b) { return a.last_name > b.last_name ? 1 : -1});
                            $.each(data, function(i, v) {
                                var newUserNode = makeUserBlock(v, memberSample);
                                membersContainer.append(newUserNode);
                            })
                            loaderImg.after(membersContainer);
                            loaderImg.remove();
                            if (document.PersonCard) {
                                document.PersonCard.auto();
                            }
                        },
                        error: function() {
                            loaderImg.addClass('g-hidden');
                            loaderImg.after('<div class="b-warning">'+ i18n.LoadingFailedTryAgainLater +'</div>');

                        }
                    });
                }
                trigger.addClass('b-access-list__group__members-trigger_state_opened');
            },
            function() {
                membersContainer.addClass('g-hidden');
                trigger.removeClass('b-access-list__group__members-trigger_state_opened');
            }
        )

        deleteButton.click(function(){
            var type = groupItemNode.data('type');
            groupItemNode.remove();

            groups[id] = null;
            delete data[id];
            total[type]--;

            if (!total[type]) {
                headers[type].addClass('g-hidden');
            }

            checkAndHideClearItem();
        })
    }

    function joinGroupKeys(groups) {
        return joinObjKeys(groups, "url");
    }

    function joinUserKeys(users) {
        ids = [];
        for (var key in users) {
            var u = users[key];
            if (u) {
                var login = u.login_ld ? u.login_ld : u.login;
                ids.push(login);
            }
        }
        return ids.join(',');
    }

    function joinObjKeys(obj_list, key, delimiter) {
        if (!delimiter) {
            delimiter = ",";
        }
        if (!key) {
            key = "id";
        }

        var ids = [];
        for (var k in obj_list) {
            var obj = obj_list[k];
            if (obj) {
                var val = obj[key];

                if (val) {
                    ids.push(val);
                }
            }
        }
        return ids.join(delimiter);
    }

    function markSaveButton() {
        $('.b-selector__buttons').addClass('b-selector__buttons_type_warning');
    }


    function checkAndHideClearItem() {
        if (!total.user && !total.departments && !total.services && !total.intra) {
            clearItem.addClass('g-hidden');
            pendingAccessList.addClass('g-hidden');
        };
    }

    function showClearItem() {
        clearItem.removeClass('g-hidden');
        pendingAccessList.removeClass('g-hidden');
    }
}

})(jQuery, window.Lego);
