(function($, Lego){

Lego.block['b-alpha'] = function(params){
    var block = $(this),
        letContainer = $('.b-alpha__letters',this),
        mlsContainer = $('.b-alpha__maillists',this),
        filters = $('.b-alpha__filter',this),
        all_switch = $('.b-alpha__filter.all',this),
        filter_switch = $('.b-alpha__filter.filtered',this),
        startclass = block.attr('class'),
        lettersLis = $('li',letContainer),
        lettersLinks = $('a',letContainer),
        lettersData = {},
        filter_enabled = $.cookie("b-alpha_filter_enabled");

        currentL = params.letter,
        currentML = params.maillist,
        freshness_edge = params.freshness_edge;

    // Сохраняем в дом нодах Буквы на которые они будут ссылать
    lettersLinks.each(function(){
        this.letter = this.onclick().letter;
    })

    lettersLinks.click(function(){
        selectLetter(this.letter);
    })

    if (currentL) selectLetter(currentL);

    all_switch.click(function(){
        $.cookie("b-alpha_filter_enabled", null,
            {
                path: "/"
            });
    });

    filter_switch.click(function(){
        $.cookie("b-alpha_filter_enabled", "1",
            {
                expires: 7,
                path: "/"
            });
    });

    filters.click(function(){
        var $this = $(this);

        if (!$this.hasClass('b-alpha__filter-active')) {
            filters.removeClass('b-alpha__filter-active');
            $(this).addClass('b-alpha__filter-active');

            block.attr('class', startclass);
            if ((this.onclick !== null) && (typeof this.onclick !== 'undefined')) {
                block.addClass((this.onclick()) ? this.onclick().modifier : '');
            }
        }
    })

    if (filter_enabled) {
        filter_switch.click();
    } else {
        all_switch.click();
    }

     /**
	 * Показывает рассылки на заданную букву, переключает указатель текущей буквы.
	 * @param {String} letter буква
	 * @return {true | false} успешность
	 */
	function selectLetter(letter) {
	    lettersLis.removeClass('selected');

		lettersLinks
            .filter(function(){return this.letter == letter})
            .closest('li')
            .addClass('selected');

		// Если список для буквы уже загружен, не загружать повторно
		if (!lettersData[letter]) {
			loadLetter(letter);
			return false;
		}

		// Отобразить список
		mlsContainer.html(getListHtml(lettersData[letter], true));
		setFolderSwitcherEvents();
		return false;
	}


    /**
	 * Строит и возвращает HTML код для списка (дерева) рассылок
	 * @param {Array} list  Список рассылок
	 * @return {String}  HTML код
	 */
    function getListHtml(list, root) {
		var cl = '';
		if (root) {
			cl = ' class="b-maillist-list"';
		}
		var s = '';
		for (var i = 0; i < list.length; i++) {
			s += getItemHtml(list[i]);
		}
		return '<ul' + cl + '>' + s + '</ul>';
	}




    /**
	 * Строит и возвращает HTML код для одного элемента списка (дерева) рассылок
	 * @param {Object} item  Элемент списка рассылок
	 * @return {String}  HTML код
	 */
	function getItemHtml(item) {
		var s = '', cl = '';
		if (item.is_open == 0) {
			if (item.is_access == 1 /*|| !list.subscribers*/) {
				cl = 'b-icon-mail-key';
			} else {
				cl = 'b-icon-mail-lock';
			}
		}

		if (item.noLink) {
			cl += ' not-subscribed';
		}

		var uri = '/lists/' + item.name + (item.my ? '/?m=1' : '/');
		var plus = item.children ? ' <a href="' + uri + '" onclick="return false" class="b-icon-minus"><i class="b-icon"><i></i></i></a>' : '';
		var liClass = '';
		if (item.children) {
			if (item.opened || (currentML + '.').indexOf(item.name + '.') == 0) {
				liClass = ' opened';
			} else {
				liClass = ' closed';
			}
		}

        if (item.relevance < freshness_edge) {
            liClass += ' irrelevant';
        }

        liClass = ' class="' + liClass + '"';

        if (item.is_subscribed == 1) {
            cl += (cl ? ' ' : '') + 'subscribed';
        }

        var cssClass = cl ? ' class="' + cl + '"' : '';
		if (item.name == currentML) {

			var selBegin = '<div class="selected">';
			var selEnd = '</div>';

			s += '<li' + liClass + '>' + selBegin + plus + '<span' + cssClass + '><i class="b-icon"><i></i></i>' + item.title + '</span>' + selEnd;
		} else {
			if (item.noLink) {
				s += '<li' + liClass + '>' + plus + '<span' + cssClass + '><i class="b-icon"><i></i></i>' + item.title + '</span>';
			} else {
				s += '<li' + liClass + '>' + plus + '<a' + cssClass + ' href="' + uri + '"><i class="b-icon"><i></i></i>' + item.title + '</a>';
			}
		}
		if (item.children) {
			s += getListHtml(item.children);
		}
		s += '</li>';
		return s;
	}



    /**
	 * Устанавливает обработчики событий click всем "плюсикам"
	 * @return {void}
	 */
	function setFolderSwitcherEvents() {
		$(".b-icon-minus",mlsContainer).click(function(){
            $(this).closest('li').toggleClass('opened').toggleClass('closed');
            return false;
        })
	}

	/**
	 * Ajax-style загрузка списка рассылок для буквы
	 * @param {String} letter
	 * @return {void}
	 */
	function loadLetter(letter) {
        $.getJSON('/api/letter/' + letter + '.json', function(d) {
            lettersData[letter] = d;
            selectLetter(letter);
        })
	}
}

})(jQuery, window.Lego);
