/**
 * Created by fantasy on 20.06.14.
 * Copy from https://github.yandex-team.ru/tools/center/blob/master/media/js/js-autocomplete_maillists.js
 */

include("b-autocomplete.js");

(function($){
    (function () {
        if (!document['b-autocomplete.css']) {
            document['b-autocomplete.css'] = true;
            var css  = document.createElement("link");
            css.rel = "stylesheet";
            css.type = "text/css";
            css.href = "//ml.yandex-team.ru/css/b-autocomplete_maillists.css";
            document.getElementsByTagName("head")[0].appendChild(css);
        }
    })();

    function getValue(row, params) {
        if (params.value && params.value.indexOf("%")!=-1) {
            var r = params.value;
            for (var i in row) {
                r = r.replace("%"+i, row[i]);
            }
            return r;
        }
        if (params.value && row[params.value]) {
            return row[params.value];
        }
        return row.name.indexOf("@")==-1 ? row.name + "@" : row.name;
    }

    $.fn.maillistsAutocomplete = function(opt) {
        if (!this.length) {
            return;
        }

        $(this).each(function() {

            var params = opt || (this.onclick ? this.onclick() : {});

            var url = "/api/lists/autocomplete/";
            if (params.is_imap!=undefined) {
                url += "?imap=" + (params.is_imap ? "1" : "0");
            }

            var options = {
                minChars: 1,
                multiple: params.multiple,
                max: 10,
                width: "auto",
                scrollHeight: "600px",
                dataType: "jsonp",
                resultsClass: "b-autocomplete b-autocomplete_maillists",
                parse: function(data) {
                    return $.map(eval(data), function(row) {
                        return {
                            data: row,
                            value: row.name,
                            result: getValue(row, params)
                        }
                    });
                },
                formatItem: function(row, i, max) {
                    if (row.name && row.name.indexOf("@")!=-1) {
                    	var pos = row.name.indexOf("@");
                        var login = row.name.substr(0, pos);
                        var name_domain = row.name.substr(pos);
                    } else {
                        var login = row.name;
                        var name_domain = "";
                    }
                    if (row.email && row.email.indexOf("@")!=-1) {
                        var email_domain = row.email.substr(row.email.indexOf("@"));
                    } else {
                        var email_domain = "";
                    }
                    return login +
                            (name_domain ? name_domain : (email_domain?email_domain:"")) +
                        '&nbsp;<br/>' +
                        (row.info ? row.info.substr(0, 50) + (row.info.length>50 ? "…" : "") + "<br />" : "");
                }

            };
            if (params.selectFirst != undefined) {
                options.selectFirst = params.selectFirst;
            }
            if (params.limit) {
                options.max = params.limit;
            }
            if (params.scrollHeight) {
                options.scrollHeight = params.scrollHeight;
            }
            if (params.multiple) {
                options.multiple = true;
                if (params.multipleSeparator) {
                    options.multipleSeparator = params.multipleSeparator;
                } else {
                    params.multipleSeparator = ",";
                }
                var resultValues = {};
            }

            $(this).autocomplete(url, options).result(function(event, data, shmata) {
                if (!params.disable_hidden) {
                    if (params.hidden && data[params.hidden]) {
                        var result_field = params.hidden;
                    } else {
                        var result_field = "name";
                    }
                    var inputName = $(this).attr("name") +"__"+ result_field;
                    var input = $("[name="+ inputName +"]");
                    if (!input.length) {
                        input = $('<input type="hidden" name="'+ inputName +'" />');
                        $(this).after(input);
                    }
                    if (params.multiple) {
                        var values = $(this).val().split(params.multipleSeparator);
                        for (var i in values) {
                            values[i] = $.trim(values[i]);
                        }
                        resultValues[getValue(data, params)] = data[result_field];
                        var res = [];
                        for (var i in resultValues) {
                            if ($.inArray(i, values) != -1) {
                                res.push(resultValues[i]);
                            } else {
                                delete resultValues[i];
                            }
                        }
                        input.val(res.join(params.multipleSeparator));
                    } else {
                        input.val(data[result_field]);
                    }
                }

                if (params.result && params.result.apply) {
                    params.result.apply(this, [data]);
                }
                if (params.clearField) {
                    $(this).val("");
                }
            });
        });
    }

    $(document).ready(function() {
        $("input.js-autocomplete_maillists, .js-autocomplete_maillists input, textarea.js-autocomplete_maillists, .js-autocomplete_maillists textarea").maillistsAutocomplete();
    });
})(jQuery);