(function($, Lego){

Lego.block['b-group-expand'] = function(params){
    var block = $(this),
        groupNodes = $(".b-group-expand__group_node", block),
        membersSample = $('.b-group-expand__js-sample-members',block).removeClass('b-group-expand__js-sample-members'),
        memberSample = $('.b-group-expand__js-sample-member',block).removeClass('b-group-expand__js-sample-member'),
        i18n = params.i18n;

    function getMembersApiUrl(group_url) {
        return "//center.yandex-team.ru/api/v1/groups/" + group_url + "/all_members.json";
    }

    // Функция создания элемента-пользователя (для добавления в список участников группы)
    function makeUserBlock(user, template_block) {
        var loginField = user.login_ld ? 'login_ld' : 'login',
            newUserItem = template_block.clone(),
            htmlContent = newUserItem.html(),
            fullName = [user.last_name, user.first_name].join(' ').trim(),
            newHtmlContent = sprintf(htmlContent,
                user[loginField],
                fullName[0],
                fullName.slice(1)
                );
        newUserItem.html(newHtmlContent);
        $(".auto-person-card-fixed", newUserItem).removeClass('auto-person-card-fixed');
        return newUserItem
    }

    function setGroupToggler(index) {
        var groupItemNode = $(this),
            trigger = $('.b-group-expand__group__members-trigger', groupItemNode),
            loaderImg = $('.b-group-expand__group__loader', groupItemNode),
            membersContainer = null;

        var id = groupItemNode.get(0).onclick().url;

        trigger.toggle(
            function(){
                if (membersContainer) {
                    membersContainer.removeClass('g-hidden');
                } else {
                    loaderImg.removeClass('g-hidden');
                    $('.b-warning', groupItemNode).remove();

                    $.ajax({
                        url: getMembersApiUrl(id),
                        dataType: "jsonp",
                        type: 'GET',
                        success: function(data) {
                            membersContainer = membersSample.clone().removeClass('g-hidden');
                            membersContainer.empty();

                            data.sort(function(a, b) { return a.last_name > b.last_name ? 1 : -1});
                            $.each(data, function(i, v) {
                                var newUserNode = makeUserBlock(v, memberSample);
                                membersContainer.append(newUserNode);
                            })
                            loaderImg.after(membersContainer);
                            loaderImg.remove();
                            if (document.PersonCard) {
                                document.PersonCard.auto();
                            }
                        },
                        error: function() {
                            loaderImg.addClass('g-hidden');
                            loaderImg.after('<div class="b-warning">'+ i18n.LoadingFailedTryAgainLater +'</div>');

                        }
                    });
                }
                trigger.addClass('b-group-expand__group__members-trigger_state_opened');
            },
            function() {
                if (membersContainer) {
                    membersContainer.addClass('g-hidden');
                } else {
                    $('.b-warning', groupItemNode).remove();
                }
                trigger.removeClass('b-group-expand__group__members-trigger_state_opened');
            }
        )
    };

    groupNodes.each(setGroupToggler);

}


})(jQuery, window.Lego);
