(function($, Lego){

Lego.block['b-mini-search'] = function(params){
    var block = $(this),
        letContainer = $('.b-mini-search__part_names',this),
        mlsContainer = $('.b-mini-search__maillists',this),
        filters = $('.b-mini-search__filter',this),
        all_switch = $('.b-mini-search__filter.all',this),
        filter_switch = $('.b-mini-search__filter.filtered',this),
        search_button = $('.b-mini-search__search_button', this);
        startclass = block.attr('class'),
        part_namesLis = $('li',letContainer),
        part_namesLinks = $('a',letContainer),
        namepartData = {},
        filter_enabled = $.cookie("b-mini-search_filter_enabled"),

        currentN = params.part_name,
        currentML = params.maillist,
        freshness_edge = params.freshness_edge;

    // Сохраняем в дом нодах Буквы на которые они будут ссылать
    part_namesLinks.each(function(){
        this.part_name = this.onclick().part_name;
    })

    part_namesLinks.click(function(){
        selectpart_name(this.part_name);
    })

    if (currentN) selectpart_name(currentN);

    all_switch.click(function(){
        $.cookie("b-mini-search_filter_enabled", null,
            {
                path: "/"
            });
    });

    filter_switch.click(function(){
        $.cookie("b-mini-search_filter_enabled", "1",
            {
                expires: 7,
                path: "/"
            });
    });

    search_button.click(function(e){
        var $this = $(this);
        e.preventDefault();
        block.attr('class', startclass);
        loadpart_name(this.onclick().part);
    });

    filters.click(function(){
        var $this = $(this);

        if (!$this.hasClass('b-mini-search__filter-active')) {
            filters.removeClass('b-mini-search__filter-active');
            $(this).addClass('b-mini-search__filter-active');

            block.attr('class', startclass);
            if ((this.onclick !== null) && (typeof this.onclick !== 'undefined')) {
                block.addClass((this.onclick()) ? this.onclick().modifier : '');
            }
        }
    })

    if (filter_enabled) {
        filter_switch.click();
    } else {
        all_switch.click();
    }

     /**
	 * Показывает рассылки , переключает указатель текущей буквы.
	 * @param {String} namepart
	 * @return {true | false} успешность
	 */
	function selectpart_name(namepart) {
	    part_namesLis.removeClass('selected');

		part_namesLinks
            .filter(function(){return this.namepart == namepart})
            .closest('li')
            .addClass('selected');

		// Если список для буквы уже загружен, не загружать повторно
		if (!namepartData[namepart]) {
			loadpart_name(namepart);
			return false;
		}

		// Отобразить список
		mlsContainer.html(getListHtml(namepartData[namepart], true));
		setFolderSwitcherEvents();
		return false;
	}


    /**
	 * Строит и возвращает HTML код для списка (дерева) рассылок
	 * @param {Array} list  Список рассылок
	 * @return {String}  HTML код
	 */
    function getListHtml(list, root) {
		var cl = '';
		if (root) {
			cl = ' class="b-maillist-list"';
		}
		var s = '';
		for (var i = 0; i < list.length; i++) {
			s += getItemHtml(list[i]);
		}
		return '<ul' + cl + '>' + s + '</ul>';
	}


    /**
	 * Строит и возвращает HTML код для одного элемента списка (дерева) рассылок
	 * @param {Object} item  Элемент списка рассылок
	 * @return {String}  HTML код
	 */
	function getItemHtml(item) {
		var s = '', cl = '';
		if (item.is_open == 0) {
			if (item.is_access == 1 /*|| !list.subscribers*/) {
				cl = 'b-icon-mail-key';
			} else {
				cl = 'b-icon-mail-lock';
			}
		}

		if (item.noLink) {
			cl += ' not-subscribed';
		}

		var uri = '/lists/' + item.name + (item.my ? '/?m=1' : '/');
		var plus = item.children ? ' <a href="' + uri + '" onclick="return false" class="b-icon-minus"><i class="b-icon"><i></i></i></a>' : '';
		var liClass = '';
		if (item.children) {
			if (item.opened || (currentML + '.').indexOf(item.name + '.') == 0) {
				liClass = ' opened';
			} else {
				liClass = ' closed';
			}
		}

        if (item.relevance < freshness_edge) {
            liClass += ' irrelevant';
        }

        liClass = ' class="' + liClass + '"';

        if (item.is_subscribed == 1) {
            cl += (cl ? ' ' : '') + 'subscribed';
        }

        var cssClass = cl ? ' class="' + cl + '"' : '';
		if (item.name == currentML) {

			var selBegin = '<div class="selected">';
			var selEnd = '</div>';

			s += '<li' + liClass + '>' + selBegin + plus + '<span' + cssClass + '><i class="b-icon"><i></i></i>' + item.title + '</span>' + selEnd;
		} else {
			if (item.noLink) {
				s += '<li' + liClass + '>' + plus + '<span' + cssClass + '><i class="b-icon"><i></i></i>' + item.title + '</span>';
			} else {
				s += '<li' + liClass + '>' + plus + '<a' + cssClass + ' href="' + uri + '"><i class="b-icon"><i></i></i>' + item.title + '</a>';
			}
		}
		if (item.children) {
			s += getListHtml(item.children);
		}
		s += '</li>';
		return s;
	}

    /**
	 * Устанавливает обработчики событий click всем "плюсикам"
	 * @return {void}
	 */
	function setFolderSwitcherEvents() {
		$(".b-icon-minus",mlsContainer).click(function(){
            $(this).closest('li').toggleClass('opened').toggleClass('closed');
            return false;
        })
	}

	/**
	 * Ajax-style загрузка списка рассылок для части названия
	 * @param {String} namepart
	 * @return {void}
	 */
	function loadpart_name(namepart) {
        $.ajax({
            url: '/api/lists/search.json?q=' + namepart,
            dataType: 'json',
            success: function(d){
                namepartData[namepart] = d;
                selectpart_name(namepart);
            }
        })
	}

}

})(jQuery, window.Lego);
