(function($, Lego) {

Lego.block['b-subscribers_access'] = function(params) {
    var alinks = $('.b-subscribers__allow',this),
        glinks = $('.b-subscribers__grant',this),
        dlinks = $('.b-subscribers__deny',this),
        all = $('.b-subscribers__allow-all',this),
        ajaxhandler = params.ajaxhandler;

    alinks.click(function(){
        sendData($(this), this.onclick().user,'allow', gettext('MSG.ACCESS_GRANTED'));
        all.remove();
    });

    glinks.click(function(){
        sendData($(this),this.onclick().user,'grant', gettext('MSG.ACCESS_GRANTED'));
        all.remove();
    });

    dlinks.click(function(){
        sendData($(this),this.onclick().user,'deny', gettext('MSG.DENY_REQUEST'));
        all.remove();
    });

    all.click(function(){
        sendData($(this),this.onclick().user,'allow', gettext('MSG.ACCESS_FOR_ALL'), function(){
            alinks.remove();
            dlinks.remove();
        });
    });

    function sendData($link,user,action,oktext,callback){
        $.ajax({
            url: ajaxhandler,
            type: "POST",
            data:
                {
                    user: user,
                    action: action
                },
            success: function(data) {
                $link.parent().html('<span class="b-subscribers__success">' + oktext + '</span>');

                if (callback)
                    callback(data);

                messages.success(data);
            },
            error: function(xhr, status, error) {
                messages.error(xhr.responseText);
            }
        });
    }
}

})(jQuery, window.Lego);
