(function($, Lego) {
    $(function(){
        $('.b-subscription').each(function(){
            var $this = $(this),
                subselector = $('.js-subselector',this),
                startvalue = subselector.val(),
                steps = $('.step',this).filter(function(){return !$(this).hasClass('step_unsub')}),
                subscribe_link = $('.subscribe_link', this),
                unsubscribe_link = $('.unsubscribe_link', this),
                data_input = $('input[type=hidden]', this),
                form = $('form', this),
                activestep;

            subscribe_link.click(function() {
                form.submit();
            })

            unsubscribe_link.click(function() {
                if (unsubscribe_link.hasClass('b-pseudo-link')) {
                    data_input.val("none");
                    unsubscribe_link.addClass('g-hidden');
                    unsubscribe_link.next().removeClass('g-hidden');
                } else {
                    data_input.val("none");
                    form.submit();
                }
            })

            subselector.change(function(){
                var s = subselector.val();
                data_input.val(s);
                if (s && s!=startvalue) {
                    activateStep(1);
                } else {
                    activateStep(0);
                }
            })

            function activateStep(number) {
                if (activestep == number) return;
                steps.removeClass('step_current step_blocked step_done');
                steps.each(function(i){
                    var $this = $(this);
                    if (i < number) {
                        $this.addClass('step_done');
                    } else if(i > number) {
                        $this.addClass('step_blocked');
                    }
                    if (i == number) $(this).addClass('step_current');
                });
                activestep = number;
            }
        })

        $('.b-subscription .js-auth').click(function(){
            Lego.block['b-auth-domik_popup'].login();
            return false;
        })
    })
})(jQuery, window.Lego);