<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:lego="https://lego.yandex-team.ru"
    exclude-result-prefixes=" x lego "
    version="1.0">

<xsl:template match="lego:b-textedit">
    <div>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:apply-templates select="." mode="lego:js-params"/>
        <xsl:apply-templates select="." mode="lego:content"/>
        <xsl:apply-templates select="." mode="lego:edit"/>
    </div>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-textedit" mode="lego:block-class-js">
    <xsl:text> g-js</xsl:text>
</xsl:template>

<xsl:template match="lego:b-textedit" mode="lego:js-params-content">
    <xsl:text>name:</xsl:text><xsl:value-of select="x:js-quote(lego:name(.))"/>
    <xsl:apply-templates select="." mode="lego:js-ajax-handler"/>
</xsl:template>

<xsl:template match="lego:b-textedit" mode="lego:js-ajax-handler">
    <xsl:text>,</xsl:text>
    <xsl:text>ajaxhandler:</xsl:text><xsl:value-of select="x:js-quote(lego:edit/@ajaxhandler)"/>
    <xsl:if test="lego:edit/@ajaxAddData">
        <xsl:text>, ajaxAddData:</xsl:text>
        <xsl:value-of select="lego:edit/@ajaxAddData"/>
    </xsl:if>
    <xsl:if test="lego:edit/@requestDataType!=''">
        <xsl:text>, requestDataType:</xsl:text>
        <xsl:value-of select="x:js-quote(lego:edit/@requestDataType)"/>
    </xsl:if>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-textedit" mode="lego:content">
    <p class="b-textedit__text">
        <xsl:apply-templates select="lego:html/node()" mode="lego:copy"/>
    </p>
</xsl:template>

<xsl:template match="lego:b-textedit" mode="lego:edit">
    <xsl:if test="lego:edit">
        <xsl:apply-templates select="lego:edit" mode="lego:content"/>
        <xsl:apply-templates select="." mode="lego:form"/>
    </xsl:if>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:edit" mode="lego:content">
    <span class="b-textedit__edit">
        <xsl:choose>
            <xsl:when test="node()">
                <xsl:apply-templates select="." mode="lego:copy"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:attribute name="style">
                    <xsl:text>padding-left:19px;</xsl:text>
                </xsl:attribute>
                <xsl:call-template name="lego:apply">
                    <xsl:with-param name="content">
                        <lego:b-icon-intranet lego:type="edit" />
                        <lego:b-pseudo-link>редактировать</lego:b-pseudo-link>
                    </xsl:with-param>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </span>
</xsl:template>

<xsl:template match="lego:b-textedit" mode="lego:form">
    <form class="b-textedit__form g-hidden" method="post">
        <xsl:attribute name="action">
            <xsl:choose>
                <xsl:when test="lego:edit/@action">
                    <xsl:value-of select="lego:edit/@action"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:text>#</xsl:text>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:attribute>
        <label>
            <textarea rows="3" cols="20" class="b-textedit__textarea" name="text"></textarea>
        </label>
        <xsl:variable name="save_btn"><xsl:value-of select="lego:message('b-textedit-save', 'Сохранить')" /></xsl:variable>
        <xsl:variable name="cancel_btn"><xsl:value-of select="lego:message('b-textedit-cancel', 'Отмена')" /></xsl:variable>
        <input type="submit" value="{$save_btn}" />&#160;<input class="b-textedit__cancel" type="reset" value="{$cancel_btn}" />
        <xsl:text>&#160;</xsl:text>
        <img class="b-textedit__spin g-hidden" src="//yandex.st/lego/2.2.3/common/block/b-spin/_size/b-spin_16.gif" alt="Запрос отправляется" align="top" />
    </form>
</xsl:template>

</xsl:stylesheet>
