<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:lego="https://lego.yandex-team.ru"
    xmlns:common="http://exslt.org/common"
    extension-element-prefixes="common lego"
    exclude-result-prefixes="x common lego"
    version="1.0">

<xsl:template match="/" mode="lego:locale">
    <xsl:choose>
        <xsl:when test="//lego:params/lego:locale"><xsl:value-of select="//lego:params/lego:locale"/></xsl:when>
        <xsl:otherwise>ru</xsl:otherwise>
        </xsl:choose>
    </xsl:template>


<xsl:variable name="legoxml" select="document(concat('../../lego/service/maillists/',$lego:id,'.',$lego:locale,'.xml'))/lego:page" />
<xsl:variable name="messages" select="document(concat('../../block/i-messages/messages', '.', $lego:locale,'.xml'))/lego:messages" />
<xsl:key name="lego:messages" match="lego:message" use="@id"/>

<xsl:template name="lego:message">
    <xsl:param name="id"/>
    <xsl:param name="text"/>
    <xsl:choose>
        <xsl:when test="$lego:locale = 'ru' and $text">
            <xsl:value-of select="$text"/>
        </xsl:when>
        <xsl:otherwise>
            <xsl:for-each select="$messages">
                <xsl:value-of select="key('lego:messages', $id)"/>
            </xsl:for-each>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<!-- костыль, заменяющий поведение i-django из blocks-intranet в отношении футера -->
<xsl:template match="/root/lego:b-foot">
    <div>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <!--<xsl:apply-templates select="." mode="lego:wai"/>-->
        <xsl:apply-templates select="lego:layout"/>
    </div>
</xsl:template>



</xsl:stylesheet>

