(function($){
    (function () {
        if (!document['b-autocomplete.css']) {
            document['b-autocomplete.css'] = true;
            var css  = document.createElement("link");
            css.rel = "stylesheet";
            css.type = "text/css";
            css.href = "//center.yandex-team.ru/media/css/_b-autocomplete_staff.css";
            document.getElementsByTagName("head")[0].appendChild(css);
        }
    })();

    function getValue(row, params) {
        if (params.value && params.value.indexOf("%")!=-1) {
            var r = params.value;
            for (var i in row) {
                if (row[i]) {
                    r = r.replace("%"+i, row[i]);
                } else {
                    r = r.replace("%"+i, "");
                }
            }
            return r;
        }
        if (params.value && row[params.value]) {
            return row[params.value];
        }
        return row.first_name + (row.last_name ? " "+row.last_name : "");
    }

    $.fn.staffAutocompleteMod = function(opt) {
        if (!this.length) {
            return;
        }

        $(this).each(function() {

            var params = opt || (this.onclick ? this.onclick() : {});

            var url = "//center.yandex-team.ru/api/autocomplete/multi/";
            var delim = "?";
            if (params.is_dismissed!=undefined) {
                url += delim + "is_dismissed=" + (params.is_dismissed ? "1" : "0");
                delim = "&";
            }
            if (params.fields) {
                url += delim + "fields=" + params.fields;
            }

            var options = {
                minChars: 1,
                multiple: params.multiple,
                max: 15,
                width: "auto",
                scrollHeight: "600px",
                dataType: "jsonp",
                resultsClass: "b-autocomplete b-autocomplete_staff",
                types: "staff",
                extraParams: {
                    types: "staff"
                },
                parse: function(data) {
                    return $.map(eval(data), function(row) {
                        return {
                            data: row,
                            value: row.login,
                            result: getValue(row, params)
                        }
                    });
                },
                formatItem: function(row, i, max) {
                    return "<div>"+ (row.login?'<img src="//center.yandex-team.ru/user/avatar/'+ row.login +'/square" class="userpic" />':'') + row.first_name + (row.last_name?" "+row.last_name:"") + (row.login ? " ("+ row.login + (row.work_phone?", "+row.work_phone:"") +")" : "") +"&nbsp;<br/><small>"+ row.department__name +"&nbsp;</small><br /></div>";
                }

            };
            if (params.selectFirst != undefined) {
                options.selectFirst = params.selectFirst;
            }
            if (params.limit) {
                options.max = params.limit;
            }
            if (params.scrollHeight) {
                options.scrollHeight = params.scrollHeight;
            }
            if (params.multiple) {
                options.multiple = true;
                if (params.multipleSeparator) {
                    options.multipleSeparator = params.multipleSeparator;
                } else {
                    params.multipleSeparator = ",";
                }
                var resultValues = {};
            }

            $(this).autocomplete(url, options).result(function(event, data, shmata) {
                if (!params.disable_hidden) {
                    if (params.hidden && data[params.hidden]) {
                        var result_field = params.hidden;
                    } else {
                        var result_field = "login";
                    }
                    var autoName = $(this).attr("name");
                    var inputName = (autoName ? autoName : "" ) + "__" + result_field;
                    // @todo: remove after refactoring login_ld -> login at all intranet
                    if (result_field == "login") {
                        var inputNameLd = (autoName ? autoName : "" ) + "__login_ld";
                    }

                    var input = $(this).next("input[name="+ inputName +"]");
                    // @todo: remove after refactoring login_ld -> login at all intranet
                    if (result_field == "login") {
                        var inputLd = input.next("input[name="+ inputNameLd +"]");
                        if (!inputLd.length) {
                            var inputLd = $(this).next("input[name="+ inputNameLd +"]");
                        }
                    }
                    if (!input.length) {
                        input = $('<input type="hidden" name="'+ inputName +'" />');
                        $(this).after(input);
                        // @todo: remove after refactoring login_ld -> login at all intranet
                        if (result_field == "login" && !inputLd.length) {
                            inputLd = $('<input type="hidden" name="'+ inputNameLd +'" />');
                            input.after(inputLd);
                        }
                    }
                    if (params.multiple) {
                        var values = $(this).val().split(params.multipleSeparator);
                        for (var i in values) {
                            values[i] = $.trim(values[i]);
                        }
                        resultValues[getValue(data, params)] = data[result_field];
                        var res = [];
                        for (var i in resultValues) {
                            if ($.inArray($.trim(i), values) != -1) {
                                res.push(resultValues[i]);
                            } else {
                                delete resultValues[i];
                            }
                        }
                        input.val(res.join(params.multipleSeparator));
                        // @todo: remove after refactoring login_ld -> login at all intranet
                        if (result_field == "login") {
                            inputLd.val(res.join(params.multipleSeparator));
                        }
                    } else {
                        input.val(data[result_field]);
                        // @todo: remove after refactoring login_ld -> login at all intranet
                        inputLd.val(data[result_field]);
                    }

                }

                if (params.result && params.result.apply) {
                    params.result.apply(this, [data]);
                }
                if (params.clearField) {
                    $(this).val("");
                }
            });
        });
    }

    $(document).ready(function() {
        $("input.js-autocomplete_staff_mod, .js-autocomplete_staff_mod input, textarea.js-autocomplete_staff_mod, .js-autocomplete_staff_mod textarea").staffAutocompleteMod();
    });
})(jQuery);
