
var MSG_TEMPLATE = {
    ribbon: '<div class="b-notify $msg_class$">$msg_text$<span onclick="$(this).parent().remove()" class="b-notify__close b-pseudo-link">' + gettext('MSG.CLOSE') + '</span></div>'
}

function Messager() {

    var getTemplate = function(name) {
        return MSG_TEMPLATE[name];
    }

    var render = function(templ, context) {

        for (var key in context) {
            var val = context[key];
            toString(templ);
            templ = templ.replace('$'+key+'$', val);
        }

        return templ;
    }

    var template = getTemplate('ribbon');

    this.success = function(msg) {
        $('.l-page-r').prepend(render(template, {
            msg_class: '',
            msg_text: msg
        }));
    }
    this.error = function(msg) {
        $('.l-page-r').prepend(render(template, {
            msg_class: 'b-notify_bad',
            msg_text: msg
        }));
    }

    return this;
}

var messages = Messager();
