/* 	Сворачивание и разворачивание группированного поиска

	Сворачивание и разворачивание происходит по клику на блоки с классом .openlink
	Элементы, которые надо скрыть в свернутом виде должны иметь класс .hidethis 
	Отображение элементов в свернутом виде можно изменить через класс .b-search-group_min ЭЛЕМЕНТ 
	
	enthusiast@yandex-team.ru */

$(document).ready(function () {
	// Находим в результатх поиска все ссылки на разворачивание групп
	$(".b-search-group .openlink").click(function() {
		var container = $(this).parent(".b-search-group");
		// Проверяем развернута группа или нет
		if (container.hasClass("b-search-group_min")) {
			// Плавненько открываем список писаем
			container.children("ul").slideToggle("fast");
			container.removeClass("b-search-group_min");
		} else {
			container.addClass("b-search-group_min");
			// сбрасываем в конце свойства, чтобы при клике много раз на ссылке блок каждый раз разворачивался полностью, 
			// иначе если прервать анимацию на середине, то потом объект будет анимироваться до прерванного состояния - обрезанного
			container.children("ul").stop().slideToggle("fast", function(){container.children("ul").height("")});
		}
		// Показываем/скрываем текст треда
		container.next(".text").toggle();
	});
});