/*
* Специальный js-компонент, используемый в других компонентах с формой авторизации (b-auth-domik, b-auth-bigform).
* Отключает сабмит формы при пустом логине или пароле, добавляет timestamp к запросу
*/
(function($, Lego) {

Lego.block['b-auth'] = function(params) {

    var thisLoginForm = $(this),
        disableSubmit = false,
        timestampInput = $('<input type="hidden" name="timestamp"/>');

    thisLoginForm.append(timestampInput).submit(function() {
        if(disableSubmit) return false;
        timestampInput.val(new Date().getTime());
    });

    // не даем сабмитить форму, пока логин или пароль пустые
    var fields = thisLoginForm.find('input[name=login], input[name=passwd]'),
        submit = thisLoginForm.find('input[type=submit]');
    fields.change(function() {
        disableSubmit = false;
        fields.each(function() {
            if(!$.trim($(this).val())) {
                disableSubmit = true;
            }
        });
        submit.attr('disabled', disableSubmit);
    });
    fields.change();

};

})(jQuery, window.Lego);
