(function($, Lego){

Lego.block['b-dropdown'] = function(params){
    var thisDropdown = $(this),
        thisDropdownList = thisDropdown.find('.b-dropdown__list'),
        dropdownPopup = $('<div class="b-dropdown__popup">' +
            '<iframe class="b-dropdown__iframe" frameborder="0" src="javascript:' + "'<body style=\\'background:none;overflow:hidden\\'>'" + '"></iframe>' +
            '</div>'),
        dropdownSpacer = thisDropdownList.clone(true).addClass('b-dropdown__list_clone').hide(),
        hidden = false,
        hide = (function(){
            if (hidden) return;
            dropdownPopup
                .css('visibility', 'hidden')
                .before(thisDropdownList)
                .hide();
            dropdownSpacer.hide();
            hidden = true;
        });
    
    thisDropdownList.before(dropdownPopup);
    dropdownPopup.after(dropdownSpacer);
    hide();

    $(document)
        // нажатие Esc и клик вне попапа скрывают его
        .keydown(function(e){ if(e.keyCode == 27 && !(e.metaKey || e.ctrlKey || e.altKey || e.shiftKey)) hide() })
        .click(function(e) { if(!$(e.target).is('.b-dropdown *')) hide() })
        .bind('popupsClose.lego', hide);

    $(this).find('.b-dropdown__or').click(function(e){
        e.preventDefault();
        if (thisDropdown.hasClass("b-dropdown_disabled")) {
            thisDropdown.trigger('popupDisabled.lego');
            return;
        }
        if (hidden) {
            $(document).trigger('popupsClose.lego');
            var oe = $.Event('popupOpen.lego');
            thisDropdown.trigger(oe);
            if (!oe.isDefaultPrevented()) {
                dropdownSpacer.css('display', '');

                dropdownPopup
                    .append(thisDropdownList)
                    .css('visibility', '');

                if (params.direction == 'up') {
                    dropdownSpacer.css('top', dropdownSpacer.superOffset().top - dropdownSpacer.height());

                    var popupOffsetTop = ($.browser.opera && $.browser.version <= 9.27)
                            ? 22
                            : $(window).superScrollTop() - dropdownPopup.superOffset().top + 22;

                    dropdownPopup.css('top', popupOffsetTop - dropdownPopup.height());
                }

                dropdownPopup.css('display', '');
                hidden = false;
            }
        } else { hide() }
    });
};

})(jQuery, window.Lego);

include('jquery.fn.offset.js');