<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:lego="https://lego.yandex-team.ru"
    exclude-result-prefixes=" lego "
    version="1.0">

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-dropdown">
    <div>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:apply-templates select="." mode="lego:js-params"/>
        <!-- странности inline-элементов -->
        <xsl:text>&#10;</xsl:text>        
        <ul class="b-dropdown__list">
            <xsl:apply-templates select="." mode="lego:attributes"/>
            <xsl:apply-templates select="." mode="lego:content"/>
        </ul>
    </div>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-dropdown" mode="lego:block-class-js">
    <xsl:text> g-js</xsl:text>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-dropdown" mode="lego:content">
    <xsl:apply-templates select="lego:item"/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-dropdown/lego:item">
    <li>
        <xsl:apply-templates select="." mode="lego:attributes"/>
        <xsl:apply-templates select="." mode="lego:content"/>
        <xsl:if test="position() = 1">
            <xsl:apply-templates select="../lego:or"/>
        </xsl:if>
    </li>
</xsl:template>

<xsl:template match="lego:b-dropdown/lego:item" mode="lego:class-content">
    <xsl:apply-imports/>
    <xsl:text> b-dropdown__item</xsl:text>
    <xsl:apply-templates select="." mode="lego:class-content-add"/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-dropdown/lego:item" mode="lego:class-content-add"/>
<xsl:template match="lego:b-dropdown/lego:item[@separator]" mode="lego:class-content-add">
    <xsl:text> b-dropdown__line</xsl:text>
</xsl:template>

<xsl:template match="lego:b-dropdown/lego:item[not(preceding-sibling::lego:item)]" mode="lego:class-content-add">
    <xsl:text> b-dropdown__visible</xsl:text>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-dropdown/lego:or">
    <a class="b-dropdown__or" href="">
        <xsl:apply-templates select="." mode="lego:url"/>
        <xsl:apply-templates select="." mode="lego:content"/>
    </a>
</xsl:template>

<xsl:template match="lego:b-dropdown/lego:or" mode="lego:content">
    <xsl:apply-templates select="lego:text"/>
</xsl:template>

<xsl:template match="lego:b-dropdown/lego:or/lego:text">
    <xsl:apply-templates select="lego:*"/>
</xsl:template>

<!-- ############################################################################################################## -->

</xsl:stylesheet>

