<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:lego="https://lego.yandex-team.ru"
    exclude-result-prefixes=" lego ">

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-foot//lego:design">
    <xsl:if test="$lego:params/lego:index">
        <div class="b-foot__design">
            <xsl:value-of select="lego:message('b-foot-design', 'Дизайн')"/>
            <xsl:text>&#160;— </xsl:text>
            <br/>
            <a class="b-foot__link" href="http://www.artlebedev.ru">
                <img class="b-foot__design__logo" alt="art.&#160;lebedev">
                    <xsl:attribute name="src">
                        <xsl:apply-templates select="." mode="lego:src-content"/>
                    </xsl:attribute>
                </img>
                <xsl:text> </xsl:text>
                <xsl:value-of select="lego:message('b-foot-design-artlebedev', 'Студия Артемия&#160;Лебедева')"/>
            </a>
        </div>
    </xsl:if>
</xsl:template>

<!-- FREEZE для бедных -->
<xsl:template match="lego:b-foot//lego:design" mode="lego:src-content">
    <!-- src="{$lego:lego-static-host}/blocks/b-foot/design/_year/b-foot__design_year_{@year}.png" -->
    <xsl:choose>
        <xsl:when test="@year = '2002'">//yandex.st/lego/_/SCKT2l0w5AUK2RvNTWJNgQx6xWY.png</xsl:when>
        <xsl:when test="@year = '2003'">//yandex.st/lego/_/HJNPGxNjSFj5AknqXlT57GccOLA.png</xsl:when>
        <xsl:when test="@year = '2004'">//yandex.st/lego/_/1PX_35beuu3S-fzFx1NZ2xbBm2A.png</xsl:when>
        <xsl:when test="@year = '2005'">//yandex.st/lego/_/ztHnzbq3g_dWxFULYh42n8vigUY.png</xsl:when>
        <xsl:when test="@year = '2006'">//yandex.st/lego/_/UF8zEizyx8VvEjAaf3HwBfTojjY.png</xsl:when>
        <xsl:when test="@year = '2007'">//yandex.st/lego/_/FuZOzT2Na0bcNFzlGMlTmamENsY.png</xsl:when>
        <xsl:when test="@year = '2008'">//yandex.st/lego/_/G1HXVvvYHuJokSuqefnblr-hseE.png</xsl:when>
        <xsl:when test="@year = '2009'">//yandex.st/lego/_/D5GV8sInzaTlVh7TafuX2V6uU0Q.png</xsl:when>
        <xsl:when test="@year = '2010'">//yandex.st/lego/_/A2jtGCcSlZpd59-npyd6jV_TITM.png</xsl:when>
    </xsl:choose>
</xsl:template>

<!-- ############################################################################################################## -->

</xsl:stylesheet>