<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:lego="https://lego.yandex-team.ru"
    exclude-result-prefixes=" lego "
    version="1.0">

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-head-logo">
    <div>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:apply-templates select="." mode="lego:content"/>
    </div>
</xsl:template>

<xsl:template match="lego:b-head-logo" mode="lego:content">
    <div class="{lego:name(.)}__logo">
        <a class="{lego:name(.)}__link">
            <xsl:apply-templates select="." mode="lego:url"/>
            <xsl:if test="@type = 'png-24'">
                <xsl:attribute name="class">g-png</xsl:attribute>
            </xsl:if>
            <img class="{lego:name(.)}__img" border="0" alt="{lego:message('b-head-logo-yandex', 'Яндекс')}">
                <xsl:apply-templates select="." mode="lego:src"/>
            </img>
        </a>
        <xsl:apply-templates select="lego:flag"/>
    </div>
    <xsl:apply-templates select="lego:b-head-name | lego:text"/>
    <xsl:apply-templates select="lego:nda"/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-head-logo" mode="lego:src-content">
    <xsl:text>//yandex.st/lego/_/X31pO5JJJKEifJ7sfvuf3mGeD_8.png</xsl:text>
    <!--<xsl:value-of select="concat($lego:lego-static-host, '/blocks/b-head-logo/b-head-logo.png')"/>-->
</xsl:template>

<!-- ############################################################################################################## -->

</xsl:stylesheet>
