<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:lego="https://lego.yandex-team.ru"
    version="1.0">

<xsl:output method="xml" encoding="utf-8" indent="yes"/>

<lego:comments>
    USAGE: xsltproc --stringparam locale ru b-head-tabs.raw2xml.xsl b-head-tabs.raw.advertising.xml > b-head-tabs.xml.advertising.ru.xml
</lego:comments>

<xsl:param name="locale"/>

<xsl:variable name="services" select="document(concat('../../../common/block/i-services/common.', $locale, '.xml'))/lego:services/lego:service"/>
<xsl:variable name="messages" select="document(concat('../../../common/block/i-messages/messages.', $locale, '.xml'))/lego:messages/lego:message"/>

<xsl:template match="lego:tabs">
    <xsl:comment>
        <xsl:text> This is auto-generated file. Don't edit it! Use make.sh instead. </xsl:text>
    </xsl:comment>
    <lego:b-head-tabs>
        <xsl:apply-templates/>
    </lego:b-head-tabs>
</xsl:template>

<xsl:template match="lego:more">
    <lego:more>
        <lego:b-dropdown>
            <lego:or url="http://www.yandex.ru/all">
                <lego:text>
                    <lego:b-pseudo-link>
                        <xsl:value-of select="$messages[@id = 'b-dropdown-more']"/>
                    </lego:b-pseudo-link>
                </lego:text>
                <lego:arrow/>
            </lego:or>
            <lego:item/>
            <xsl:apply-templates/>
        </lego:b-dropdown>
    </lego:more>
</xsl:template>

<xsl:template match="lego:tab">
    <lego:item service-id="{@id}">
        <xsl:copy-of select="@separator"/>
        <xsl:apply-templates select="$services[@id = current()/@id][1]"/>
    </lego:item>
</xsl:template>

<xsl:template match="lego:service">
    <lego:link url="{@url}"><xsl:value-of select="."/></lego:link>
</xsl:template>

</xsl:stylesheet>

