<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:lego="https://lego.yandex-team.ru"
    exclude-result-prefixes=" x lego "
    version="1.0">

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-head-tabs">
    <xsl:comment>noindex</xsl:comment>
    <table>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:apply-templates select="." mode="lego:js-params"/>
        <tr>
            <xsl:apply-templates select="." mode="lego:content"/>
        </tr>
        <xsl:apply-templates select="@lego:theme"/>
    </table>
    <xsl:comment>/noindex</xsl:comment>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-head-tabs" mode="lego:block-class-js">
    <xsl:text> g-js</xsl:text>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-head-tabs" mode="lego:js-params-content">
    <xsl:apply-imports/>
    <xsl:variable name="default">
        <xsl:apply-templates select="." mode="lego:param-default"/>
    </xsl:variable>
    <xsl:text>,'default':</xsl:text><xsl:value-of select="x:js-quote($default)"/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-head-tabs" mode="lego:param-default"/>

<!-- ############################################################################################################## -->

<!-- TODO: унести в b-head-tabs/_theme -->
<xsl:template match="lego:b-head-tabs/@lego:theme">
    <tr>
        <td class="b-head-tabs__corners" colspan="{count(../lego:item) + count(../lego:more)}">
            <b class="b-head-tabs__corners-b">
                <i class="b-head-tabs__corners-lt"/>
                <i class="b-head-tabs__corners-rt"/>
                <i class="b-head-tabs__corners-lb"><i class="b-head-tabs__corners-lb-i"/></i>
                <i class="b-head-tabs__corners-rb"><i class="b-head-tabs__corners-rb-i"/></i>
            </b>
        </td>
    </tr>
</xsl:template>

<xsl:template match="lego:b-head-tabs" mode="lego:content">
    <xsl:apply-templates select="lego:item | lego:more"/>
</xsl:template>

<xsl:template match="lego:b-head-tabs/lego:item" mode="lego:class-content">
    <xsl:text>b-head-tabs__tab</xsl:text>
</xsl:template>

<xsl:template match="lego:b-head-tabs/lego:more">
    <td class="b-head-tabs__tab b-head-tabs__more">
        <xsl:apply-templates select="lego:b-dropdown"/>
    </td>
</xsl:template>

<xsl:template match="lego:b-head-tabs//lego:link" mode="lego:class-content">
    <xsl:text>b-head-tabs__link</xsl:text>
</xsl:template>

<xsl:template match="lego:b-head-tabs//lego:link" mode="lego:counter-content">
    <xsl:value-of select="$lego:id"/>.tabs.<xsl:value-of select="ancestor::lego:item/@service-id"/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-head-tabs//lego:item[@current and lego:params()/lego:index]/lego:link">
    <xsl:apply-templates select="." mode="lego:content"/>
</xsl:template>

<!-- ############################################################################################################## -->

</xsl:stylesheet>

