<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:lego="https://lego.yandex-team.ru"
    exclude-result-prefixes=" lego "
    version="1.0">

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-head-toolbar">
    <xsl:apply-templates select="$lego:params/lego:b-head-toolbar"/>
</xsl:template>

<xsl:template match="/lego:b-head-toolbar">
    <table class="b-head-toolbar">
    <tr>
        <xsl:apply-templates select="." mode="lego:content"/>
    </tr>
    </table>
</xsl:template>

<xsl:template match="lego:b-head-toolbar/lego:separator">
    <td class="b-head-toolbar__separator"><i class="b-head-toolbar__gap"/></td>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-head-toolbar/lego:item" mode="lego:class-content">
    <xsl:apply-imports/>
    <xsl:text> b-head-toolbar__td</xsl:text>
</xsl:template>

<xsl:template match="lego:b-head-toolbar/lego:item[@disabled]" mode="lego:class-content">
    <xsl:apply-imports/>
    <xsl:text> b-head-toolbar__td b-head-toolbar__disabled</xsl:text>
</xsl:template>

<xsl:template match="lego:b-head-toolbar/lego:item/lego:*" mode="lego:class-content">
    <xsl:apply-imports/>
    <xsl:text> b-head-toolbar__item</xsl:text>
</xsl:template>

<xsl:template match="lego:b-head-toolbar/lego:item/lego:*" mode="lego:content">
    <i class="b-head-toolbar__icon"><i class="b-icon"><i class="b-icon__i"/></i></i>
    <i class="b-head-toolbar__text"><xsl:apply-imports/></i>
</xsl:template>

</xsl:stylesheet>

