<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:lego="https://lego.yandex-team.ru"
    exclude-result-prefixes=" x lego "
    version="1.0">

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-head-userinfo">
    <table class="b-head-userinfo">
    <tr>
        <td class="b-head-userinfo__td">
            <xsl:apply-templates select="." mode="lego:row-1"/>
        </td>
        <xsl:apply-templates select="." mode="lego:auth"/>
    </tr>
    <tr>
        <td class="b-head-userinfo__td" colspan="2">
            <xsl:apply-templates select="." mode="lego:row-2"/>
        </td>
    </tr>
    <tr>
        <td class="b-head-userinfo__td" colspan="2">
            <xsl:apply-templates select="." mode="lego:row-3"/>
        </td>
    </tr>
    <tr>
        <td class="b-head-userinfo__td" colspan="2">
            <xsl:apply-templates select="." mode="lego:row-4"/>
        </td>
    </tr>
    </table>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-head-userinfo" mode="lego:row-1">
    <xsl:apply-templates select="lego:service"/>
</xsl:template>

<xsl:template match="lego:b-head-userinfo[lego:auth()]" mode="lego:row-1">
    <xsl:apply-templates select="lego:userpic"/>
    <xsl:apply-templates select="lego:b-head-user"/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-head-userinfo" mode="lego:row-2">
    <xsl:apply-templates select="lego:setup"/>
    <xsl:apply-templates select="lego:help"/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-head-userinfo" mode="lego:row-3"/>

<xsl:template match="lego:b-head-userinfo[lego:auth()]" mode="lego:row-3">
    <xsl:apply-templates select="lego:service"/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-head-userinfo" mode="lego:row-4">
    <xsl:apply-templates select="lego:region | lego:search"/>
</xsl:template>

<!-- TODO: вынести в b-head-userinfo/b-head-userinfo.search.xsl -->
<xsl:template match="lego:b-head-userinfo/lego:search">
    <div class="b-head-userinfo__search">
        <xsl:apply-templates/>
    </div>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-head-userinfo" mode="lego:auth">
    <td class="b-head-userinfo__entry">
        <xsl:call-template name="lego:b-pseudo-link">
            <xsl:with-param name="url">
                <xsl:apply-templates select="." mode="lego:url-content"/>
            </xsl:with-param>
            <xsl:with-param name="content" select="lego:message('b-head-userinfo-enter', 'Войти')"/>
            <xsl:with-param name="counter">
                <xsl:apply-templates select="." mode="lego:counter-content"/>
            </xsl:with-param>
        </xsl:call-template>
        <xsl:apply-templates select="lego:b-auth-domik"/>
    </td>
</xsl:template>

<xsl:template match="lego:b-head-userinfo[lego:auth()]" mode="lego:auth">
    <td class="b-head-userinfo__exit">
        <a class="b-head-userinfo__link">
            <xsl:apply-templates select="." mode="lego:counter"/>
            <xsl:apply-templates select="." mode="lego:url"/>
            <xsl:value-of select="lego:message('b-head-userinfo-exit', 'Выход')"/>
        </a>
    </td>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-head-userinfo" mode="lego:url-content">
    <xsl:value-of select="$lego:params/lego:passport-host"/>
    <xsl:text>/passport?mode=</xsl:text>
    <xsl:choose>
        <xsl:when test="lego:auth()">
            <xsl:text>logout</xsl:text>
            <xsl:if test="$lego:params/lego:yandexuid">
                <xsl:text>&amp;yu=</xsl:text><xsl:value-of select="$lego:params/lego:yandexuid"/>
            </xsl:if>
        </xsl:when>
        <xsl:otherwise>
            <xsl:text>auth&amp;msg=</xsl:text>
            <xsl:value-of select="x:urlencode('utf-8', $lego:params/lego:passport-msg)"/>
        </xsl:otherwise>
    </xsl:choose>
    <xsl:if test="$lego:params/lego:retpath">
        <xsl:text>&amp;retpath=</xsl:text><xsl:value-of select="x:urlencode('utf-8', $lego:params/lego:retpath)"/>
    </xsl:if>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-head-userinfo" mode="lego:counter-content">
    <xsl:value-of select="$lego:id"/><xsl:text>.login.enter</xsl:text>
</xsl:template>

<xsl:template match="lego:b-head-userinfo[lego:auth()]" mode="lego:counter-content">
    <xsl:value-of select="$lego:id"/><xsl:text>.login.exit</xsl:text>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-head-userinfo/lego:*">
    <xsl:variable name="url">
        <xsl:apply-templates select="." mode="lego:url-content"/>
    </xsl:variable>
    <xsl:variable name="block-class">
        <xsl:apply-templates select="." mode="lego:block-class-content"/>
    </xsl:variable>
    <div class="{$block-class}">
        <xsl:choose>
            <xsl:when test="$url != ''">
                <a class="b-head-userinfo__link" href="{$url}">
                    <xsl:apply-templates select="." mode="lego:counter"/>
                    <xsl:apply-templates select="." mode="lego:content"/>
                </a>
            </xsl:when>
            <xsl:otherwise>
                <strong class="b-head-userinfo__current">
                    <xsl:apply-templates select="." mode="lego:content"/>
                </strong>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:apply-templates select="." mode="lego:add"/>
    </div>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-head-userinfo/lego:*" mode="lego:add"/>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-head-userinfo/lego:*" mode="lego:counter-content">
    <xsl:value-of select="concat($lego:id, '.login.', local-name())"/>
</xsl:template>

</xsl:stylesheet>

