/**
 * Загрузчик виртуальной клавиатуры
 */

(function($, Lego) {

    Lego.block['b-keyboard-loader'] = function(params) {
        var $body = $(document.body),
            $window = $(window),
            targetElem = this;

        targetElem.click(function() {
            var $this = $(this);

            var defaultLang = (this.className.match(/b-keyboard-loader_lang_(\w+)/)) ? this.className.match(/b-keyboard-loader_lang_(\w+)/)[1] : '';

            if ($body.find('.b-keyboard').length == 0) {
                var jsFiles = [
                    Lego.params['lego-static-host'] + '/common/block/b-keyboard-popup/_b-keyboard-popup.js',
                    Lego.params['lego-static-host'] + '/common/block/b-keyboard/_b-keyboard.js',
                    Lego.params['lego-static-host'] + '/common/block/b-dropdown/_b-dropdown.js'
                ];

                var cssFiles = [
                    Lego.params['lego-static-host'] + '/common/block/b-keyboard-popup/_b-keyboard-popup.css',
                    Lego.params['lego-static-host'] + '/common/block/b-keyboard/_b-keyboard.css'
                ];

                if ($.browser.msie) {
                    cssFiles.push(
                            Lego.params['lego-static-host'] + '/common/block/b-keyboard-popup/_b-keyboard-popup.ie.css',
                            Lego.params['lego-static-host'] + '/common/block/b-keyboard/_b-keyboard.ie.css'
                            );
                }

                $this.append('<i class="b-keyboard-loader__progress"></i>');

                $.xLazyLoader({
                    name: 'b-keyboard',
                    js: jsFiles,
                    css: cssFiles,
                    success: function() {
                        // Создаем b-keyboard-popup
                        Lego.block['b-keyboard-popup']({lang: defaultLang});
                        // Этот блок b-keyboard - временный, он нужен только для того, чтобы можно было вызвать Lego.blockInit
                        $body.append('<div class="b-keyboard g-js" onclick="return {name: \'b-keyboard\', lang: \'' + defaultLang + '\'};"></div>');
                        Lego.blockInit($body, '.b-keyboard');
                        $this.find('.b-keyboard-loader__progress').remove();
                        $window.trigger('keyboardOpened');
                        $(document).trigger('popupsClose.lego');
                    }
                });
            } else {
                keyboardClose();
            }

            return false;
        });

        /**
         *
         * @param {Event} [e]
         */
        function keyboardClose(e) {
            // если e != undefined, то вызов пришел из события keyboardClose, поэтому принудительно закрываем клавиатуру
            var method = e ? 'addClass' : 'toggleClass',
                $popup = $body.find('.b-keyboard-popup');
            
            if ($popup.length) {
                $body.find('.b-keyboard-popup__gap')[method]('g-hidden');
                if ($body.find('.b-keyboard-popup')[method]('g-hidden').hasClass('g-hidden')) {
                    // оповещение о закрытии клавиатуры
                    $window.trigger('keyboardClosed');
                } else {
                    // оповещение об открытии клавиатуры
                    $window.trigger('keyboardOpened');
                }
            }
        }

        // Keyboard API
        $window
            // событие для открытия клавиатуры
            .bind('keyboardOpen', function() {
                targetElem.trigger('click');
            })
            // событие для закрытия клавиатуры
            .bind('keyboardClose', keyboardClose);
    };

})(jQuery, window.Lego);

include('jquery.xLazyLoader.js');
