<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:lego="https://lego.yandex-team.ru"
    exclude-result-prefixes=" lego "
    version="1.0">

<xsl:import href="../i-pager/i-pager.xsl"/>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-pager" mode="lego:html">
    <div class="b-pager g-js">
        <xsl:apply-templates select="." mode="lego:js-params"/>
        <xsl:apply-templates select="lego:title"/>
        <xsl:apply-templates select="lego:prev"/>
        <xsl:apply-templates select="lego:next"/>
        <xsl:apply-templates select="lego:pages"/>
        <xsl:apply-templates select="lego:sorted"/>
    </div>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-pager/lego:title">
    <b class="b-pager__title">
        <xsl:apply-templates/>
    </b>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-pager/lego:pages">
    <div class="b-pager__pages">
        <xsl:apply-templates select="lego:*"/>
    </div>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-pager/lego:prev">
    <span class="b-pager__inactive">
        <i class="b-pager__key"><i class="b-pager__arr">&#8592;</i> Ctrl</i>
        <xsl:text> </xsl:text>
        <xsl:apply-templates select="." mode="lego:content"/>
    </span>
</xsl:template>

<xsl:template match="lego:b-pager/lego:prev[@url]">
    <span class="b-pager__active">
        <i class="b-pager__key"><i class="b-pager__arr">&#8592;</i> Ctrl</i>
        <xsl:text> </xsl:text>
        <a class="b-pager__prev">
            <xsl:apply-templates select="." mode="lego:url"/>
            <xsl:apply-templates select="." mode="lego:content"/>
        </a>
    </span>
</xsl:template>

<xsl:template match="lego:b-pager/lego:next">
    <span class="b-pager__inactive">
        <xsl:apply-templates select="." mode="lego:content"/>
        <xsl:text> </xsl:text>
        <i class="b-pager__key">Ctrl <i class="b-pager__arr">&#8594;</i></i>
    </span>
</xsl:template>

<xsl:template match="lego:b-pager/lego:next[@url]">
    <span class="b-pager__active">
        <a class="b-pager__next">
            <xsl:apply-templates select="." mode="lego:url"/>
            <xsl:apply-templates select="." mode="lego:content"/>
        </a>
        <xsl:text> </xsl:text>
        <i class="b-pager__key">Ctrl <i class="b-pager__arr">&#8594;</i></i>
    </span>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-pager/lego:pages/lego:*">
    <b class="b-pager__current">
        <xsl:apply-templates select="." mode="lego:content"/>
    </b>
    <xsl:text> </xsl:text>
</xsl:template>

<xsl:template match="lego:b-pager/lego:pages/lego:*[@url]">
    <a class="b-pager__page">
        <xsl:apply-templates select="." mode="lego:url"/>
        <xsl:apply-templates select="." mode="lego:content"/>
    </a>
    <xsl:text> </xsl:text>
</xsl:template>

<xsl:template match="lego:sorted">
    <p>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:apply-templates select="lego:text"/>
        <xsl:text> </xsl:text>
        <xsl:apply-templates select="lego:item"/>
    </p>
</xsl:template>

<xsl:template match="lego:sorted/lego:item">
    <a class="b-pager__link">
        <xsl:apply-templates select="." mode="lego:url"/>
        <xsl:apply-templates/>
    </a>
    <xsl:text> </xsl:text>
</xsl:template>
<xsl:template match="lego:sorted/lego:item[@lego:selected]">
    <b class="b-pager__select">
        <xsl:apply-templates/>
    </b>
    <xsl:text> </xsl:text>
</xsl:template>

<!-- ############################################################################################################## -->

</xsl:stylesheet>

