<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:lego="https://lego.yandex-team.ru"
    xmlns:ya="urn:yandex-functions"
    extension-element-prefixes=" ya "
    exclude-result-prefixes=" lego ya "
    version="1.0">

<!-- quick menu:
        input/b-search.input.xsl
        button/b-search.button.xsl
        sample/b-search.sample.xsl
        precise/b-search.precise.xsl
        advanced/b-search.advanced.xsl
-->

<!-- ############################################################################################################## -->

<xsl:variable name="lego:b-search-default-input-name" select="'text'"/>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-search">
    <!-- TODO: унести margin:0 в CSS-->
    <form style="margin:0">
        <xsl:apply-templates select="." mode="lego:attributes"/>
        <xsl:apply-templates select="." mode="lego:form-attributes"/>
        <xsl:apply-templates select="." mode="lego:counter"/>
        <xsl:apply-templates select="." mode="lego:content"/>
    </form>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-search" mode="lego:counter-event">
    <xsl:text>onsubmit</xsl:text>
</xsl:template>

<xsl:template match="lego:b-search" mode="lego:counter-content">
    <xsl:value-of select="$lego:id"/><xsl:text>.search.form</xsl:text>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-search" mode="lego:content">
    <table class="b-search">
    <xsl:apply-templates select="." mode="lego:block-attributes"/>
    <tr>
        <xsl:apply-templates select="lego:input"/>
        <xsl:apply-templates select="lego:button"/>
    </tr>
    <xsl:apply-templates select="." mode="lego:under"/>
    </table>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-search" mode="lego:hidden"/>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-search" mode="lego:under">
    <xsl:if test="$lego:params/lego:b-search/lego:input/lego:sample | $lego:params/lego:b-search/lego:input/lego:precise | lego:input/lego:advanced | $lego:params/lego:b-search/lego:under">
        <tr>
            <td class="b-search__under" colspan="2">
                <xsl:apply-templates select="lego:input" mode="lego:under"/>
            </td>
        </tr>
    </xsl:if>
</xsl:template>

<xsl:template match="lego:b-search[@lego:type = 'double']" mode="lego:under">
    <xsl:if test="$lego:params/lego:b-search/lego:input/lego:sample | $lego:params/lego:b-search/lego:input/lego:precise | lego:input/lego:advanced | $lego:params/lego:b-search/lego:under">
        <tr>
            <xsl:for-each select="lego:input">
                <td></td>
                <td class="b-search__under">
                    <xsl:apply-templates select="." mode="lego:under"/>
                </td>
            </xsl:for-each>
        </tr>
    </xsl:if>
</xsl:template>

<!-- ############################################################################################################## -->

</xsl:stylesheet>

