<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:lego="https://lego.yandex-team.ru"
    xmlns:ya="urn:yandex-functions"
    extension-element-prefixes=" ya "
    exclude-result-prefixes=" x lego ya "
    version="1.0">

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-search/lego:input">
    <xsl:apply-templates select="." mode="lego:label"/>
    <td class="b-search__input">
        <div class="b-input">
            <xsl:apply-templates select="." mode="lego:content"/>
        </div>
    </td>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-search/lego:input" mode="lego:label"/>

<xsl:template match="lego:b-search[@lego:type = 'double']/lego:input" mode="lego:label">
    <td class="b-search__label-{1 + count(preceding-sibling::lego:input)}">
        <label class="b-search__label">
            <xsl:attribute name="for">
                <xsl:apply-templates select="." mode="lego:auto-id-content"/>
            </xsl:attribute>
            <xsl:apply-templates select="." mode="lego:label-content"/>
        </label>
    </td>
</xsl:template>

<xsl:template match="lego:b-search/lego:input" mode="lego:label-content">
    <xsl:apply-templates select="$lego:params/lego:b-search/lego:input[not(@name != current()/@name)]/lego:label"/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-search/lego:input" mode="lego:content">
    <xsl:apply-templates select="lego:hint"/>
    <input tabindex="1">
        <xsl:apply-templates select="." mode="lego:attributes"/>
        <xsl:apply-templates select="." mode="lego:input-attributes"/>
        <xsl:apply-templates select="." mode="lego:js-params"/>
    </input>
    <xsl:apply-templates select="lego:b-keyboard-loader"/>
</xsl:template>

<xsl:template match="lego:b-search/lego:input" mode="lego:class">
    <xsl:call-template name="lego:attribute">
        <xsl:with-param name="name" select="'class'"/>
        <xsl:with-param name="content">
            <xsl:apply-templates select="." mode="lego:class-content"/>
        </xsl:with-param>
    </xsl:call-template>
</xsl:template>
<xsl:template match="lego:b-search/lego:input" mode="lego:class-content">
    <xsl:text>b-input__text g-js</xsl:text>
</xsl:template>

<xsl:template match="lego:b-search/lego:input[lego:hint]" mode="lego:id-content">
    <xsl:apply-templates select="." mode="lego:auto-id-content"/>
</xsl:template>

<!-- TODO: Переделать схему с lego:class -->
<xsl:template match="lego:b-search/lego:input[@*[namespace-uri() = 'https://lego.yandex-team.ru']]" mode="lego:class-content">
    <xsl:apply-imports/>
    <xsl:text> g-js</xsl:text>
</xsl:template>

<!-- ############################################################################################################## -->

<!-- для "double"-формы id-шники нужны всегда - для меток -->
<xsl:template match="lego:b-search[@lego:type = 'double']/lego:input" mode="lego:id">
    <xsl:apply-templates select="." mode="lego:auto-id"/>
</xsl:template>

<xsl:template match="lego:b-search/lego:input[not(@name)]" mode="lego:name-content">
    <xsl:value-of select="$lego:b-search-default-input-name"/>
</xsl:template>

<xsl:template match="lego:b-search/lego:input" mode="lego:value-content">
    <xsl:value-of select="$lego:params/lego:b-search/lego:input[not(@name != current()/@name)]/lego:value"/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-search/lego:input" mode="lego:under">
    <xsl:apply-templates select="lego:b-suggest"/>
    <xsl:apply-templates select="lego:advanced"/>
    <xsl:apply-templates select="lego:sample | lego:precise"/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-search/lego:input" mode="lego:js-params-content">
    <xsl:apply-imports/>

    <xsl:text>,focus:</xsl:text>
    <xsl:choose>
        <xsl:when test="@focus = 'yes'">true</xsl:when>
        <xsl:otherwise>false</xsl:otherwise>
    </xsl:choose>
</xsl:template>


</xsl:stylesheet>

