(function($, Lego){

Lego.block['b-suggest'] = function(params){
    var thisSuggest = $(this),
        suggestHolder = $('<div class="b-suggest-holster"><div class="b-suggest-popup"><div class="b-suggest-list">' +
            '<iframe frameborder="0" src="javascript:' + "'<body style=\\'background:none\;overflow:hidden\\'>'" + '"></iframe>' +
            (thisSuggest.hasClass('b-suggest_gradient') ?
                '<img class="b-suggest-bg" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAADICAIAAACmkByiAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAP5JREFUeNpkjVmSwyAMRLn/VScxmH2zGbVAxKl8vOpN2KqPoQbRF/eiId83b7Jf96SvfaxuPDd6AyQ3+dY1frp6LX9dvAN49EzvE/Klzxto6zcrwN4JydjQQft6z9oWtarcHpnIrapU295SLYumSpk6KSqWTF1TodBtztxPX3mDhwJ0yD4Xhu9TYmIqKuSpAvcxKp8iq0t5vk1x40Lgje9C+gKbhfdeBfLg9PNOesnbk9rlHcHq3OYkrPPM7s7ZQQ2pto5BBpKfvTH2qzPGqOM0y9uVpyLDA61P7l7mo/yOeuneRrMXFZC1/iD9n6Z/HQd3coP80sfe3ocB/wIMAE9bQenCh4SKAAAAAElFTkSuQmCC" alt="" />'
                : '') +
            '<ul class="b-suggest-items"></ul>' +
            (params['close'] ? '<div class="b-suggest-close"><a class="b-pseudo-link" href="javascript:void(0)">Закрыть</a></div>' : '') +
            '<div class="b-suggest-nah">Включены <a class="b-suggest-nah__link" href="http://nahodki.yandex.ru/about_suggest.xml">мои запросы</a></div>' +
            '</div></div></div>').hide(),
        suggestItems =  suggestHolder.find('.b-suggest-items'),
        suggestInput = thisSuggest.closest('form').find('input[name="' + (params['for'] || 'text') +'"]'),
        suggestForm = suggestInput.closest('form'),

        dataUrl = params.url || (params.host || '') + (params.path || ''),
        //dataUrl = dataUrl || 'http://suggest-dev.cloudkill.yandex.ru/suggest-market?callback=?',

        cache = {'' : []}, // кешируем запросы на сервер

        // Статистика использования подсказки
        stats = {usageType: 0, region: '', nah: 0, position: 0, session: (new Date().getTime() + Math.round(Math.random() * 10000)), queryTimes: [], _keydownTriggered: false},

        isNahodki = false,
        lr = '',

        // функция удалённого запроса данных, выбирается или кроссфреймовая или обычная
        getData = (function() {
            // для кроссфреймовости нужна jquery.crossframeajax.html в домене саджеста
            var frameSrc = (dataUrl.match(/^[^\/]*\/\/[^\/]+\//) || [location.protocol + '//' + location.host])[0] +
                    'jquery.crossframeajax.html',
                frame = $('<iframe style="display:none" src="' + frameSrc + '"></iframe>').appendTo('body')[0],
                origDomain = document.domain,
                rootDomain = document.domain.match(/([^.]+\.)?[^.]+$/)[0],
                retry = 10,
                ajaxFunc;

            try { document.domain != rootDomain && (document.domain = rootDomain) } catch(e){} // пытаемся выставить домен в корневой, чтобы можно было общаться между фреймами

            // попытаемся несколько раз получить кроссфреймовую функцию
            (function wait(){
                if (retry) {
                    try {
                        ajaxFunc = frame.contentWindow.$.crossframeAjax;
                        if (ajaxFunc) { getData = ajaxFunc } else { throw true } //
                    } catch(e) {
                        retry--;
                        setTimeout(wait, 42);
                    }
                } else {
                    try { document.domain != origDomain && (document.domain = origDomain) } catch(e){} // пытаемся вернуть домен обратно
                }
            })();

            return $.ajax;
        })(),

        // функция запроса и показа подсказок по определённой строке
        show = (function(){
            // вспомогательная функция построения html-я списка
            function buildItemHtml(item) {
                switch(item[0]) {
                    case 'href': // подсказка-ссылка
                        if (item[3] && item[3].nah && item[3].nah == 1) { // ссылка из Моих находок (не посещенная, не добавляем b-suggest-elem-link)
                            isNahodki = true;
                            stats.nah = 1;
                            return '<li><span class="b-suggest-elem b-suggest-elem_nah">' + item[1] + '</span></li>';
                        }
                        return '<li><a class="b-suggest-elem b-suggest-elem-link" href="' + item[2] + '"><span class="content">' +
                            item[1] + '</span></a></li>';
                    case 'nav': // навигационная ссылка
                        return '<li><a class="b-suggest-elem b-suggest-elem-link b-suggest-elem_nav" target="_blank" href="http://' + item[2] + '">' +
                            '<span class="content"><span class="link">' + item[2] + '</span>' +
                            '<span class="info">&nbsp;&mdash; ' + item[1] + '</span></span></a></li>';
                    case 'html': // подсказка с произвольным html
                        return '<li><span class="b-suggest-elem b-suggest-elem-link">' + item[1] + '</span></li>';
                    default: // обычная подсказка
                        return '<li><span class="b-suggest-elem b-suggest-elem-link"><span class="content">'
                            + item + '</span></span></li>';
                }
            }
            // вспомогательная функция построения html-я списка подсказок
            function show(data) {
                isNahodki = false;
                stats.nah = 0;
                stats.usageType = 1;
                stats.region = data[data.length - 1]['r'];
                var items = data[1];
                countSelectable = items.length;
                if (!(count = items ? items.length : 0)) return hide();
                var hrefs = data[2] || [];
                suggestItems.get(0).innerHTML = ''; // NOTE: нечестное удаление внутренностей, с потенциальными мемориликами зато быстрое
                suggestItems.html(
                    $.map(items, function(item, i){
                        return buildItemHtml(!!hrefs[i] ? ['href', item, hrefs[i]] : item);
                    }).join('')
                );

                if (isNahodki === true || data[data.length - 1]['n'] && data[data.length - 1]['n'] == '1') {
                    $(suggestHolder).find('.b-suggest-close').hide();
                    $(suggestHolder).find('.b-suggest-nah').show();
                } else {
                    $(suggestHolder).find('.b-suggest-close').show();
                    $(suggestHolder).find('.b-suggest-nah').hide();
                }

                suggestHolder.show();
                // Сохраняем для статистики действие "выбрали стрелками и отредактировали"
                if (hidden === false && stats._keydownTriggered === true) {
                    stats.usageType = 4;
                    stats._keydownTriggered = false;
                }
                hidden = false;
            }
            var requestNumber = 0; // переменная для обеспечения последовательности удалённых запросов
            return function(value) {
                if (closed) return; // если подсказки были закрыты пользователем, не делаем ничего
                current(0, value);
                var data = cache[value + '*' + dataUrl];
                if (data) {
                    show(data);
                } else {
                    var timeout = setTimeout(hide, 700); // если ответа долго нет, прячем подсказки
                    requestNumber += 1;
                    // Запоминаем timestamp отправки запроса
                    var queryTime = new Date();

                    // Получаем значение параметра lr
                    var lrField = document.getElementsByName('lr'),
                        lrParam = window.location.toString().match(/lr=(.*?)(&|$)/);

                    if (lrField.length > 0) lr = lrField[0].value;
                    else if (lrParam && lrParam.length > 0) lr = lrParam[1];
                    else lr = '';

                    getData({
                        url: dataUrl,
                        data: {
                            part: suggestInput.attr('value'),
                            lr: lr
                        },
                        dataType: 'json',
                        type: 'GET',
                        timeout: 700,
                        success: (function(i, url) { return function(data){
                            if (!data) return;
                            cache[value + '*' + url] = data;
                            clearTimeout(timeout);
                            if (i == requestNumber) show(data);
                            // Сохраняем в статистику время выполнения запроса
                            stats.queryTimes.push(new Date() - queryTime);
                        }})(requestNumber, dataUrl)
                    });
                }
            }
        })(),
        // вспомогательная ф-ия перехода по ссылке в новом окне
        openInNewWindow = function(url) {
            $('<form action="' + url + '" method="get" target="_blank" />')
                .appendTo($('body'))
                .submit()
                .remove();
        },

        closed = false, // храним факт закрытия подсказок пользователем
        hidden = true, // храним факт скрыты ли подсказки, безотносительно пользователем или автоматически
        metaKeyPressed = false, // храним факт нажатия метаклавиш
        // функция скрытия, в том числе меняет пользовательский текст
        hide = (function(){
            if (hidden) return;
            suggestHolder.hide();
            current(0, suggestInput.attr('value'));
            hidden = true;
        }),
        count = 0, // текущее количество вариантов
        countSelectable = 0, // текущее количество выбираемых вариантов
        // функция переключения варианта подсказки
        // i подразумевается 0 (для выбора пользовательского текста), 1 или -1 (для перемещения вверх/вниз)
        // value устанавливает пользовательский текст
        current = (function(){
            var current = 0,
                userValue = suggestInput.attr('value');
            return function(i, value) {
                if (value != undefined) userValue = value;
                current = i ? current + i : 0;
                if (current < 0) current = countSelectable;
                if (current > countSelectable) current = 0;
                if (current > 0) stats.position = current; // Positive 'current' value holds the position of a current item
                var item = suggestItems.find('.b-suggest-elem')
                        .removeClass('b-suggest-elem_selected')
                        .eq(current? current - 1 : 1000).addClass('b-suggest-elem_selected'), // затычка про 1000, потому что в Safari 3 undefined в eq работает некорректно
                    itemValue = item.text(),
                    currentValue = item.is('.b-suggest-elem_nav') ? lastUserValue : (itemValue || userValue),
                    attrHref = item.attr('href'),
                    currentHref = itemValue && attrHref? attrHref : '';
                if (item.is('.b-suggest-elem_nah')) stats.nah = 2;
                if (suggestInput.attr('value') != currentValue) suggestInput.attr('value', currentValue);
                suggestInput.data('href', currentHref);
            }
        })();

    $('.b-suggest-elem')
        .live('mouseenter', function() {
            $(this).addClass('b-suggest-elem_state_hover');
        })
        .live('mouseleave', function() {
            $(this).removeClass('b-suggest-elem_state_hover');
        });

    var focused = suggestInput.data('lego:focused');
    if(focused) suggestInput.blur();
    suggestInput.attr('autocomplete', 'off');
    if(focused) suggestInput.focus();
    if (params.text) suggestInput.attr('value', params.text);
    thisSuggest.append(suggestHolder);

    // кнопка "закрыть" закрывает попап
    var closeInProgress = false; // переменная для синхронизации событий закрытия по ссылке и ухода из инпута
    suggestHolder.find('.b-suggest-close')
        .mousedown(function(){ closeInProgress = true })
        .mouseup(function(){ closeInProgress = false })
        .click(function(){
            current(0);
            hide();
            closed = true; // запоминаем, что пользователь вручную закрыл подсказки
            suggestInput.focus();
        });

    // делаем так, чтобы по ссылке "Включены мои запросы" действительно можно было перейти
    suggestHolder.find('.b-suggest-nah__link')
        .mousedown(function() { window.location = this.href })

    // скрываем при уходе из инпута
    suggestInput.blur(function(){ if (!closeInProgress) hide() });

    // скрываем при глобальном лего-событии закрытия попапов
    $(document)
        .bind('popupsClose.lego', hide)
        // запоминаем нажатие метаклавиш
        .keydown(function(e){ if (e.metaKey || e.ctrlKey || e.altKey || e.shiftKey) metaKeyPressed = true })
        .keyup(function(e){ metaKeyPressed = false })
        .mouseup(function(){ closeInProgress = false });

    suggestItems
        // клик по варианту выбирает его как пользовательский текст и выполняет переход
        .mousedown(function(e){
            closeInProgress = true; // предотвращаем проблемы со скрытием на уход из инпута
            var t = $(e.target);
            if (t.is('li *')) {
                mouseDownElem = t.closest('.b-suggest-elem');
                if(!mouseDownElem.hasClass('b-suggest-elem_nav')) {
                    /* Find item's position in the list while mouse-clicking (begin) */
                    var container = t.parents('ul'),
                        targetClassName = e.target.className;

                    if (targetClassName && targetClassName.split(' ').length > 0) {
                        container.find('.' + e.target.className.split(' ')[0]).each(function(i) {
                            if (this == e.target) {
                                stats.position = i + 1;
                                if ($(e.target).hasClass('b-suggest-elem_nah')) {
                                    stats.nah = 2;
                                }
                            }
                        });
                    }
                    /* Find item's position in the list (end) */

                    current(0, mouseDownElem.text());
                    suggestInput.data('href', mouseDownElem.attr('href'));
                    stats.usageType = 2;
                    closed = true;
                    mouseDownElem.get(0).tagName.toLowerCase() != "a" &&
                        setTimeout(function() { suggestForm.submit() }, 0); // выполняем переход
                }
            }
            return false;
        })
        .click(function(){
            $.browser.msie? hide() : suggestInput.focus();
        });

    var lastUserValue = '', // переменная для слежения за последним набранным пользователем текстом
        mouseDownElem,
        preventSubmit = false;

    suggestForm.submit(function(e){
        if (preventSubmit) {
            return preventSubmit = false;
        }

        var href = suggestInput.data('href') || stats.followAfterSubmit;

        if (!stats.submitted) {
            e.preventDefault();
            // Сохраняем URL, если есть, потому что он потеряется после сабмита статистики (сработает hide())
            if (href) stats.followAfterSubmit = href;
            submitStats();
            window.setTimeout(function() { suggestForm.submit() }, 500);
        } else if (href) {
            e.preventDefault();
            location.href = href;
        }
    });

    function onEscape() { // вспомогательная функция, вызывается когда на инпуте или списке нажат esc
        current(0);
        hide();
        closeInProgress = false;
    }

    suggestInput
        .keydown(function(e){
            switch(e.keyCode) {
                // нажатие стрелок перемещает курсор и открывает список если он закрыт
                case 38: // UP
                case 40: // DOWN
                    e.preventDefault();
                    stats._keydownTriggered = true;
                    if (hidden) {
                        closed = false; // считаем что пользователь вызвал подсказки вручную
                        show(suggestInput.attr('value'));
                    } else {
                        stats.usageType = 3;
                        current(e.keyCode - 39); // пользуемся особенностями кодов клавиш "вверх"/"вниз" ;-)
                    }
                    break;

                case 13: // Enter
                    break;

                case 27: // ESC
                    closeInProgress = true;
                    break;
            }
        })
        .keypress(function(e) {
            switch(e.keyCode) {
                case 13:
                    var selectedItem = suggestItems.find('.b-suggest-elem_selected');
                    if(selectedItem.is('.b-suggest-elem_nav')) {
                        preventSubmit = true;
                        openInNewWindow(selectedItem.attr('href'));
                    }
                    return false;

                case 27: // ESC
                    return false;

            }
        })
        .keyup(function(e){
            switch(e.keyCode) {
                // ничего не делаем ибо работает keydown
                case 38: // UP
                case 40: // DOWN
                    break;

                // при нажатии Enter совершаем переход
                case 13: // Enter
                    stats.usageType = 3;
                    suggestForm.submit();
                    break;

                case 27:
                    onEscape();
                    break;

                default:
                    // проверяем изменился ли текст и пытаемся подсказать
                    if (lastUserValue != suggestInput.attr('value')) {
                        lastUserValue = suggestInput.attr('value');
                        clearInterval(keypressTimeout);
                        var keypressTimeout = setTimeout(function(){ show(suggestInput.attr('value')) }, 1); // задержка для тех, кто быстро печатает
                    }
                    break;
            }
        });

    setTimeout(function() {
        // фокус в поле показывает подсказки
        suggestInput.focus(function(e) {
            // NOTE: костыль из-за LEGO-476
            if ($(e.target).data('b-suggest') !== false) {
                closeInProgress = false;
                show(suggestInput.attr('value'))
            }
        });
    }, 42);

    // событие для апдейта параметров
    // NOTE: пока умеет только учитывать изменения пути (без хоста)
    thisSuggest.bind('updateParams.lego', function(e, newParams){
        if (!newParams) return;
        var newDataUrl = (dataUrl.match(/^[^\/]*\/\/[^\/]+\//)[0] || '') + (newParams.path || '');
        if (newDataUrl) dataUrl = newDataUrl;
        if ('closed' in newParams) closed = newParams.closed;
    });

    function submitStats() {
        var suggestType = (Lego.params.id == 'serp') ? '1' : '2';
        if (Lego.params && Lego.params['show-counters']) Lego.cp(0, 2873, suggestType + '.' + stats.usageType + '.' + stats.position + '.' + stats.nah + '/session=' + stats.session + '/region=' + stats.region + '/times=' + stats.queryTimes.join("."));
        stats.submitted = true;
    }
};

})(jQuery, window.Lego);
