<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:lego="https://lego.yandex-team.ru"
    exclude-result-prefixes=" x lego "
    version="1.0">

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-suggest">
    <div>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:apply-templates select="." mode="lego:js-params"/>
    </div>
</xsl:template>

<xsl:template match="lego:b-suggest" mode="lego:block-class-js">
    <xsl:text> g-js</xsl:text>
</xsl:template>

<xsl:template match="lego:b-suggest" mode="lego:js-params-content">
    <xsl:apply-imports/>

    <!-- lego:b-suggest всегда вложен в lego:input -->
    <xsl:variable name="value">
        <xsl:apply-templates select="ancestor::lego:input[1]" mode="lego:value-content"/>
    </xsl:variable>
    <xsl:text>,text:</xsl:text><xsl:value-of select="x:js-quote($value)"/>
    <xsl:variable name="name">
        <xsl:apply-templates select="ancestor::lego:input[1]" mode="lego:name-content"/>
    </xsl:variable>
    <xsl:text>,'for':</xsl:text><xsl:value-of select="x:js-quote($name)"/>

    <xsl:variable name="url">
        <xsl:apply-templates select="." mode="lego:url-content"/>
    </xsl:variable>
    <xsl:text>,url:</xsl:text><xsl:value-of select="x:js-quote($url)"/>

    <xsl:text>, close:</xsl:text>
    <xsl:choose>
        <xsl:when test="@lego:close = 'close'">true</xsl:when>
        <xsl:otherwise>false</xsl:otherwise>
    </xsl:choose>
</xsl:template>

<!-- ############################################################################################################## -->

</xsl:stylesheet>

