<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:lego="https://lego.yandex-team.ru"
    exclude-result-prefixes=" x lego "
    version="1.0">

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-tabbed-pane/lego:tabs">
    <ul>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:apply-templates select="." mode="lego:js-params"/>
        <xsl:apply-templates select="lego:tab"/>
    </ul>
</xsl:template>

<xsl:template match="lego:b-tabbed-pane/lego:tabs[@lego:type = 'horizontal']">
    <table>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:apply-templates select="." mode="lego:js-params"/>
        <tr>
            <xsl:apply-templates select="lego:tab"/>
        </tr>
    </table>
</xsl:template>

<xsl:template match="lego:b-tabbed-pane/lego:tabs" mode="lego:js-params-content">
    <xsl:text>name:</xsl:text><xsl:value-of select="x:js-quote(lego:name(.))"/>
    <xsl:text>,bind:</xsl:text><xsl:value-of select="x:js-quote(../@id)"/>
</xsl:template>

<xsl:template match="lego:panels | lego:tabs" mode="lego:block-class-js"> g-js</xsl:template>


<xsl:template match="lego:b-tabbed-pane/lego:tabs/lego:tab">
    <li>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:apply-templates select="." mode="lego:content"/>
    </li>
</xsl:template>

<xsl:template match="lego:b-tabbed-pane/lego:tabs[@lego:type = 'horizontal']/lego:tab">
    <td>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:apply-templates select="." mode="lego:content"/>
    </td>
</xsl:template>

<xsl:template match="lego:b-tabbed-pane/lego:tabs/lego:tab" mode="lego:content">
    <xsl:apply-templates select="." mode="lego:block-attributes"/>
    <xsl:apply-templates select="." mode="lego:js-params"/>
    <xsl:apply-templates select="." mode="lego:content-copy"/>
</xsl:template>

<xsl:template match="lego:b-tabbed-pane/lego:tabs/lego:tab" mode="lego:content-copy">
    <xsl:apply-templates mode="lego:copy"/>
</xsl:template>
<xsl:template match="lego:b-tabbed-pane/lego:tabs/lego:tab[lego:content]" mode="lego:content-copy">
    <xsl:apply-templates select="lego:content/node()" mode="lego:copy"/>
</xsl:template>

<xsl:template match="lego:b-tabbed-pane/lego:tabs/lego:tab" mode="lego:js-params-content">
    <xsl:variable name="bind" select="@bind | lego:bind/text()"/>
    <xsl:text>bind: </xsl:text>
    <xsl:apply-templates select="$bind"/>
</xsl:template>

<xsl:template match="@bind | lego:bind/text()">
    <xsl:if test="position() = 1 and position() != last()">[</xsl:if>
    <xsl:if test="position() != 1"> ,</xsl:if>
    <xsl:value-of select="x:js-quote(.)"/>
    <xsl:if test="position() = last() and position() != 1">]</xsl:if>
</xsl:template>


<xsl:template match="lego:b-tabbed-pane/lego:panels">
    <div>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:apply-templates select="." mode="lego:js-params"/>
        <xsl:apply-templates select="lego:panel"/>
    </div>
</xsl:template>

<xsl:template match="lego:b-tabbed-pane/lego:panels" mode="lego:block-class-content"> g-js</xsl:template>

<xsl:template match="lego:b-tabbed-pane/lego:panels" mode="lego:js-params-content">
    <xsl:text>name:</xsl:text><xsl:value-of select="x:js-quote(lego:name(.))"/>
    <xsl:text>,id:</xsl:text><xsl:value-of select="x:js-quote(../@id)"/>
</xsl:template>



<xsl:template match="lego:b-tabbed-pane/lego:panels/lego:panel">
    <div>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:apply-templates select="." mode="lego:js-params"/>
        <xsl:apply-templates select="." mode="lego:content"/>
    </div>
</xsl:template>

<xsl:template match="lego:b-tabbed-pane/lego:panels/lego:panel" mode="lego:class-content">
    <xsl:text>b-tabbed-pane__panel</xsl:text>
    <xsl:if test="not(@current = 'yes')"> g-hidden</xsl:if>
</xsl:template>

<xsl:template match="lego:b-tabbed-pane/lego:panels/lego:panel" mode="lego:js-params-content">
    <xsl:text>id: </xsl:text>
    <xsl:value-of select="x:js-quote(@id)"/>
</xsl:template>

<xsl:template match="lego:panel" mode="lego:content">
    <xsl:apply-templates mode="lego:copy"/>
</xsl:template>

<!-- ############################################################################################################## -->

</xsl:stylesheet>

