<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:lego="https://lego.yandex-team.ru"
    xmlns:func="http://exslt.org/functions"
    extension-element-prefixes=" func "
    exclude-result-prefixes=" lego "
    version="1.0">

<!-- ############################################################################################################## -->

<xsl:template name="lego:b-user">
<xsl:param name="title"/>
<xsl:param name="link"/>
<xsl:param name="counter"/>
    <b class="b-user">
        <xsl:choose>
            <xsl:when test="$link">
                <a class="b-user__link" href="{$link}">
                    <xsl:if test="$counter">
                        <xsl:attribute name="onmousedown"><xsl:value-of select="$counter"/></xsl:attribute>
                    </xsl:if>
                    <b class="b-user__first-letter"><xsl:value-of select="substring($title, 1, 1)"/></b><xsl:value-of select="substring($title, 2)"/>
                </a>
            </xsl:when>
            <xsl:otherwise>
                <b class="b-user__first-letter"><xsl:value-of select="substring($title, 1, 1)"/></b><xsl:value-of select="substring($title, 2)"/>
            </xsl:otherwise>
        </xsl:choose>
    </b>
</xsl:template>

<func:function name="lego:b-user">
<xsl:param name="title"/>
<xsl:param name="link"/>
<xsl:param name="counter"/>
    <func:result>
        <xsl:call-template name="lego:b-user">
            <xsl:with-param name="title" select="$title"/>
            <xsl:with-param name="link" select="$link"/>
            <xsl:with-param name="counter" select="$counter"/>
        </xsl:call-template>
    </func:result>
</func:function>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-user">
    <b class="b-user">
        <xsl:apply-templates select="." mode="lego:content"/>
    </b>
</xsl:template>

<xsl:template match="lego:b-user[@url]">
    <b class="b-user">
        <a class="b-user__link">
            <xsl:apply-templates select="." mode="lego:url"/>
            <xsl:apply-templates select="." mode="lego:counter"/>
            <xsl:apply-templates select="." mode="lego:content"/>
        </a>
    </b>
</xsl:template>

<xsl:template match="lego:b-user" mode="lego:content">
    <b class="b-user__first-letter"><xsl:value-of select="substring(., 1, 1)"/></b><xsl:value-of select="substring(., 2)"/>
</xsl:template>

<!-- ############################################################################################################## -->

</xsl:stylesheet>

