<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:lego="https://lego.yandex-team.ru"
    exclude-result-prefixes=" lego "
    version="1.0">

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-vmenu">
    <ul>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:apply-templates select="." mode="lego:js-params"/>
        <xsl:apply-templates select="lego:item"/>
    </ul>
</xsl:template>

<xsl:template match="lego:b-vmenu" mode="lego:block-class-js">
    <xsl:text> g-js</xsl:text>
</xsl:template>

<xsl:template match="lego:b-vmenu/lego:item">
    <li class="item">
        <xsl:apply-templates select="." mode="lego:content"/>
    </li>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-vmenu/lego:item[@current]" mode="lego:current">
    <div class="current">
        <xsl:apply-templates select="lego:text | lego:title | lego:link"/>
    </div>
    <xsl:apply-templates select="lego:b-vmenu"/>
</xsl:template>

<xsl:template match="lego:b-vmenu[@lego:style = 'round']/lego:item[@current]" mode="lego:current">
    <div class="current">
        <i class="b-round b-round_7"><i class="l t"><i/></i><i class="r t"><i/></i></i>
        <xsl:apply-templates select="lego:text | lego:title | lego:link"/>
        <i class="b-round b-round_7"><i class="l b"><i/></i><i class="r b"><i/></i></i>
    </div>
    <xsl:apply-templates select="lego:b-vmenu"/>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-vmenu/lego:item[@current]/lego:text">
    <strong>
        <xsl:apply-templates/>
    </strong>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-vmenu//lego:switcher">
    <span class="switcher">
        <xsl:apply-templates select="." mode="lego:attributes"/>
        <i class="switcher-icon">
            <img alt="+" src="{$lego:lego-static-host}/common/block/b-vmenu/switcher/b-vmenu.switcher.gif"/>
        </i>
        <xsl:apply-templates select="lego:*"/>
    </span>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-vmenu//lego:title">
    <strong class="title{lego:if(not(parent::lego:item/preceding-sibling::lego:item), ' first')}">
        <xsl:apply-templates/>
    </strong>
</xsl:template>

</xsl:stylesheet>