<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:lego="https://lego.yandex-team.ru"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:str="http://exslt.org/strings"
    xmlns:exsl="http://exslt.org/common"
    xmlns:func="http://exslt.org/functions"
    exclude-result-prefixes=" lego x str exsl func "
    extension-element-prefixes=" func "
    version="1.0">

<xsl:include href="../i-items/i-items.xsl"/>
<xsl:include href="../i-attributes/i-attributes.xsl"/>

<!-- ############################################################################################################## -->

<xsl:variable name="lego:lego-static-host" select="'//yandex.st/lego/2.2.12'"/>

<!-- Разные дефолтные параметры, которые можно переопределить, передав их в lego:params. -->
<!-- !!! Эта переменная должна быть определена выше, чем lego:user-params-tmp -->
<xsl:variable name="lego:default-params">
    <lego:js-jquery>//js.static.yandex.net/jquery/1.3.2/_jquery.js</lego:js-jquery>
    <!-- <lego:js-jquery>//yandex.st/jquery/1.4.2/jquery.min.js</lego:js-jquery> -->

    <lego:js-common>//yandex.st/lego/2.2.19/common/js/_common.js</lego:js-common>
    <!--<lego:js-common><xsl:value-of select="$lego:lego-static-host"/>/common/js/_common.js</lego:js-common>-->

    <!-- Removed by ml/htdocs/Makefile patch to prevent invalid css link
    <lego:static-host>//<xsl:value-of select="$lego:id"/>.static.yandex.net</lego:static-host> 
    -->

    <lego:passport-host>http://passport.yandex.ru</lego:passport-host>
    <lego:passport-msg><xsl:value-of select="$lego:id"/></lego:passport-msg>
</xsl:variable>

<xsl:variable name="lego:user-params-tmp">
    <xsl:apply-templates select="/" mode="lego:params"/>
</xsl:variable>
<xsl:variable name="lego:user-params" select="exsl:node-set($lego:user-params-tmp)"/>

<xsl:variable name="lego:params" select="exsl:node-set($lego:default-params) | $lego:user-params"/>

<!-- ############################################################################################################## -->

<xsl:variable name="lego:id" select="$lego:user-params/lego:id"/>

<!-- ############################################################################################################## -->

<xsl:variable name="lego:locale">
    <xsl:apply-templates select="/" mode="lego:locale"/>
</xsl:variable>

<xsl:template match="/" mode="lego:locale">
    <xsl:text>ru</xsl:text>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template name="lego:css">
<xsl:param name="css"/>
<xsl:param name="meta" select="true()"/>
<xsl:param name="build" select="$lego:params/lego:build"/>
    <xsl:if test="$meta">
        <meta http-equiv="X-UA-Compatible" content="IE=EmulateIE7"/>
    </xsl:if>
    <xsl:variable name="build-string">
        <xsl:if test="$build">?build=<xsl:value-of select="$build"/></xsl:if>
    </xsl:variable>
    <xsl:for-each select="str:split($css, ',')">
        <xsl:comment>[if gt IE 7]>&lt;!</xsl:comment><link rel="stylesheet" href="{normalize-space(.)}.css{$build-string}"/><xsl:comment>&lt;![endif]</xsl:comment>
        <xsl:comment>[if lt IE 8]&gt;&lt;link rel=stylesheet href="<xsl:value-of select="normalize-space(.)"/>.ie.css<xsl:value-of select="$build-string"/>"&gt;&lt;![endif]</xsl:comment>
    </xsl:for-each>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template name="lego:js">
<xsl:param name="js"/>
<xsl:param name="charset" select="'utf-8'"/>
<xsl:param name="build" select="$lego:params/lego:build"/>
    <xsl:variable name="build-string">
        <xsl:if test="$build">?build=<xsl:value-of select="$build"/></xsl:if>
    </xsl:variable>
    <xsl:for-each select="str:split($js, ',')">
        <script type="text/javascript" charset="{$charset}" src="{normalize-space(.)}{$build-string}"></script>
    </xsl:for-each>
</xsl:template>

<xsl:template name="lego:js-inline">
<xsl:param name="js"/>
    <xsl:text disable-output-escaping="yes">&lt;script type="text/javascript"&gt;</xsl:text>
        <xsl:text>//</xsl:text>
        <xsl:comment>
        <xsl:text>&#10;</xsl:text>
        <xsl:value-of select="$js" disable-output-escaping="yes"/>
        <xsl:text>&#10;//</xsl:text>
        </xsl:comment>
    <xsl:text disable-output-escaping="yes">&lt;/script&gt;</xsl:text>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="/" mode="lego:init">
    <xsl:apply-templates select="." mode="lego:css-include"/>
    <xsl:apply-templates select="." mode="lego:favicon"/>
    <xsl:apply-templates select="." mode="lego:js-include"/>
    <xsl:apply-templates select="." mode="lego:js-init"/>
</xsl:template>

<xsl:template match="/" mode="lego:favicon">
    <link rel="shortcut icon">
        <xsl:attribute name="href">
            <xsl:apply-templates select="." mode="lego:favicon-content"/>
        </xsl:attribute>
    </link>
</xsl:template>

<xsl:template match="/" mode="lego:favicon-content">
    <xsl:text>/favicon.ico</xsl:text>
</xsl:template>

<xsl:variable name="lego:css-static-prefix" select="concat($lego:params/lego:static-host, '/css')"/>

<xsl:template match="/" mode="lego:css-include">
    <xsl:call-template name="lego:css">
        <xsl:with-param name="css" select="concat($lego:css-static-prefix, '/_', $lego:id)"/>
    </xsl:call-template>
</xsl:template>

<xsl:variable name="lego:js-static-prefix" select="concat($lego:params/lego:static-host, '/js')"/>

<xsl:template match="/" mode="lego:js-include">
    <xsl:apply-templates select="." mode="lego:js-include-jquery"/>
    <xsl:apply-templates select="." mode="lego:js-include-prj"/>
    <xsl:if test="$lego:locale != 'ru'">
        <xsl:apply-templates select="." mode="lego:js-include-locale"/>
    </xsl:if>
</xsl:template>

<xsl:template match="/" mode="lego:js-include-jquery">
    <xsl:call-template name="lego:js">
        <xsl:with-param name="js" select="concat($lego:params/lego:js-jquery, ',', $lego:params/lego:js-common)"/>
        <xsl:with-param name="build" select="false()"/>
    </xsl:call-template>
</xsl:template>

<xsl:template match="/" mode="lego:js-include-prj">
    <xsl:call-template name="lego:js">
        <xsl:with-param name="js" select="concat($lego:js-static-prefix, '/_', $lego:id, '.js')"/>
    </xsl:call-template>
</xsl:template>

<xsl:template match="/" mode="lego:js-include-locale">
    <xsl:call-template name="lego:js">
        <xsl:with-param name="js" select="concat($lego:lego-static-host, '/common/block/i-messages/_messages.', $lego:locale, '.js')"/>
    </xsl:call-template>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="/" mode="lego:js-init">
    <xsl:call-template name="lego:js-inline">
        <xsl:with-param name="js">
            <xsl:text>Lego.init({</xsl:text>
                <xsl:text>login:</xsl:text><xsl:value-of select="x:js-quote(x:tolower($lego:params/lego:login))"/>
                <xsl:text>,locale:</xsl:text><xsl:value-of select="x:js-quote($lego:locale)"/>
                <xsl:text>,id:</xsl:text><xsl:value-of select="x:js-quote($lego:id)"/>
                <xsl:text>,'lego-static-host':</xsl:text><xsl:value-of select="x:js-quote($lego:lego-static-host)"/>
                <xsl:if test="$lego:params/lego:passport-host">
                    <xsl:text>,'passport-host':</xsl:text><xsl:value-of select="x:js-quote($lego:params/lego:passport-host)"/>
                </xsl:if>
                <xsl:if test="$lego:params/lego:passport-msg != $lego:id">
                    <xsl:text>,'passport-msg':</xsl:text><xsl:value-of select="x:js-quote($lego:params/lego:passport-msg)"/>
                </xsl:if>
                <xsl:if test="$lego:params/lego:retpath">
                    <xsl:text>,'retpath':</xsl:text><xsl:value-of select="x:js-quote($lego:params/lego:retpath)"/>
                </xsl:if>
                <xsl:if test="$lego:params/lego:index">
                    <xsl:text>,'index':</xsl:text><xsl:value-of select="'true'"/>
                </xsl:if>
            <xsl:text>})</xsl:text>
        </xsl:with-param>
    </xsl:call-template>
</xsl:template>

<!-- ############################################################################################################## -->

<func:function name="lego:message">
<xsl:param name="id"/>
<xsl:param name="text"/>
    <func:result>
        <xsl:call-template name="lego:message">
            <xsl:with-param name="id" select="$id"/>
            <xsl:with-param name="text" select="$text"/>
        </xsl:call-template>
    </func:result>
</func:function>

<xsl:template name="lego:message">
<xsl:param name="id"/>
<xsl:param name="text"/>
    <xsl:value-of select="$text"/>
</xsl:template>

<!-- ############################################################################################################## -->

<func:function name="lego:params">
    <func:result select="$lego:params"/>
</func:function>

<!-- ############################################################################################################## -->

<func:function name="lego:auth">
    <func:result select="$lego:params/lego:login != ''"/>
</func:function>

<!-- ############################################################################################################## -->

<xsl:template name="lego:apply">
<xsl:param name="content"/>
    <xsl:apply-templates select="exsl:node-set($content)/*"/>
</xsl:template>

<!-- ############################################################################################################## -->

<func:function name="lego:child-node">
<xsl:param name="elements"/>
    <xsl:variable name="nodes">
        <xsl:element name="{name()}">
            <xsl:for-each select="str:tokenize($elements, ',| ')">
                <xsl:element name="{normalize-space(.)}"/>
            </xsl:for-each>
        </xsl:element>
    </xsl:variable>
    <func:result select="exsl:node-set($nodes)/*/*"/>
</func:function>

<!-- ############################################################################################################## -->

<xsl:template match="*" mode="lego:copy">
    <xsl:copy>
        <xsl:apply-templates select="@*" mode="lego:copy"/>
        <xsl:apply-templates mode="lego:copy"/>
    </xsl:copy>
</xsl:template>

<xsl:template match="lego:*" mode="lego:copy">
    <xsl:apply-templates select="."/>
</xsl:template>

<xsl:template match="@*" mode="lego:copy">
    <xsl:copy-of select="."/>
</xsl:template>

<!-- ############################################################################################################## -->

<!-- слишком мелкий компонент, чтобы париться с его подключениями по зависимостям -->
<xsl:template match="lego:b-icon">
    <i class="b-icon"><i/></i>
</xsl:template>

<!-- ############################################################################################################## -->

<func:function name="lego:name">
<xsl:param name="element"/>
    <xsl:choose>
        <xsl:when test="lego:is-block($element)">
            <func:result select="local-name($element)"/>
        </xsl:when>
        <xsl:otherwise>
            <func:result select="concat(local-name($element/ancestor::lego:*[lego:is-block(.)][1]), '__', local-name($element))"/>
        </xsl:otherwise>
    </xsl:choose>
</func:function>

<func:function name="lego:is-block">
<xsl:param name="element"/>
    <func:result select="translate(substring(local-name($element), 1, 2), 'blegzi', '') = '-'"/>
</func:function>

<!-- ############################################################################################################## -->

<func:function name="lego:if">
<xsl:param name="condition"/>
<xsl:param name="a"/>
<xsl:param name="b"/>
    <func:result>
        <xsl:choose>
            <xsl:when test="$condition"><xsl:value-of select="$a"/></xsl:when>
            <xsl:otherwise><xsl:value-of select="$b"/></xsl:otherwise>
        </xsl:choose>
    </func:result>
</func:function>

<!-- ############################################################################################################## -->

<func:function name="lego:max">
<xsl:param name="a"/>
<xsl:param name="b"/>
    <func:result select="lego:if($a &gt; $b, $a, $b)"/>
</func:function>

<func:function name="lego:min">
<xsl:param name="a"/>
<xsl:param name="b"/>
    <func:result select="lego:if($a &lt; $b, $a, $b)"/>
</func:function>

<!-- ############################################################################################################## -->

</xsl:stylesheet>

