<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:lego="https://lego.yandex-team.ru"
    exclude-result-prefixes=" lego "
    version="1.0">

<!-- ############################################################################################################## -->

<xsl:key name="lego:messages" match="lego:messages/lego:message" use="@id"/>

<xsl:variable name="lego:root" select="/"/>

<!-- ############################################################################################################## -->

<xsl:template name="lego:message">
<xsl:param name="id"/>
<xsl:param name="text"/>
    <xsl:choose>
        <xsl:when test="$lego:locale = 'ru' and $text">
            <xsl:value-of select="$text"/>
        </xsl:when>
        <xsl:otherwise>
            <xsl:for-each select="$lego:root">
                <xsl:value-of select="key('lego:messages', $id)"/>
            </xsl:for-each>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<!-- ############################################################################################################## -->

</xsl:stylesheet>

