<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:lego="https://lego.yandex-team.ru"
    exclude-result-prefixes=" lego "
    version="1.0">

<!-- ############################################################################################################## -->

<xsl:template match="lego:l-head">
    <xsl:apply-templates select="." mode="lego:i-metrika"/>
    <xsl:apply-templates select="." mode="lego:b-statcounter"/>
    <table class="l-head">
        <xsl:apply-templates select="." mode="lego:attributes"/>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:apply-templates select="." mode="lego:content"/>
    </table>
</xsl:template>

<xsl:template match="lego:l-head" mode="lego:content">
    <tr>
        <td class="l-head__g"><i class="l-head__gap"><xsl:apply-templates select="." mode="lego:tns"/></i></td>
        <td class="l-head__l">
            <xsl:apply-templates select="lego:b-head-logo"/>
        </td>
        <td class="l-head__gl"><i class="l-head__gap"></i></td>
        <td class="l-head__c">
            <xsl:apply-templates select="." mode="lego:l-head__c-content"/>
        </td>
        <td class="l-head__gr"><i class="l-head__gap"></i></td>
        <td class="l-head__r">
            <xsl:apply-templates select="lego:b-head-userinfo"/>
        </td>
        <td class="l-head__g"><i class="l-head__gap"></i></td>
    </tr>
</xsl:template>

<xsl:template match="lego:l-head" mode="lego:l-head__c-content">
    <xsl:apply-templates select="lego:b-head-tabs"/>
    <xsl:apply-templates select="lego:b-head-search | lego:b-head-line | lego:b-head-toolbar"/>
    <xsl:apply-templates select="lego:b-head-menu"/>
    <xsl:text> </xsl:text><!-- Fix for LEGO-45: При изменении размеров окна ссылка "ещё" налезает на другие ссылки и иногда исчезает (фф 3.0.1 под MacOS) -->
</xsl:template>

<xsl:template match="lego:l-head" mode="lego:tns">
    <xsl:attribute name="style">
        <xsl:text>background:url(//www.tns-counter.ru/V13a****yandex_ru/ru/CP1251/tmsec=</xsl:text>
        <xsl:choose>
            <xsl:when test="$lego:params/lego:tns"><xsl:value-of select="$lego:params/lego:tns"/></xsl:when>
            <xsl:otherwise>yandex_<xsl:value-of select="$lego:id"/></xsl:otherwise>
        </xsl:choose>
        <xsl:text>/0)</xsl:text>
    </xsl:attribute>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:l-head" mode="lego:i-metrika">
    <xsl:apply-templates select="../lego:i-metrika"/>
</xsl:template>

<xsl:template match="lego:l-head" mode="lego:b-statcounter">
    <xsl:apply-templates select="lego:b-statcounter"/>
</xsl:template>

</xsl:stylesheet>

