(function($, Lego){

var bHeadUser = Lego.block['b-head-user'] = function(){
    var thisBlock = $(this);

    if (Lego.params.login != '') {
        $.getJSON(
            bHeadUser.getApiUrl(),
            { locale: Lego.params.locale, login: 'yes', 'current-login': Lego.params.login },
            function(data){
                if (!data || !data.services) return;
                var login =  bHeadUser.getUserLogin(data),
                    html = '<div class="g-js b-dropdown" onclick="return {name:' + "'b-dropdown'" + '}"><ul class="b-dropdown__list">' +
                        '<li class="b-dropdown__item b-dropdown__visible">' +
                            '<a href="http://i.yandex.ru" class="b-dropdown__or">' +
                                '<span class="b-pseudo-link"><b class="b-user"><b class="b-user__first-letter">' + login.substring(0, 1) + '</b>' + login.substring(1) + '</b></span></span>' +
                            '</a>' +
                        '</li>';

                $.each(data.services, function(){
                    html += '<li class="b-dropdown__item">';
                    if (Lego.params.id == this.id && Lego.params.index) {
                        html += '<strong>' + this.title + '</strong>';
                    } else {
                        html += '<a ' +
                            'class="b-dropdown__link"' +
                            'href="' + this.url + '"' +
                            'onmousedown="Lego.ch(\'' + Lego.params.id + '.login.myservices.' + this.id + '\',this)">' +
                                this.title +
                            '</a>';
                    }
                    html += '</li>';
                });

                html += bHeadUser.getUserItems();

                html += '</ul></div>';

                thisBlock.find('.b-user').replaceWith(html);
                Lego.blockInit(thisBlock, '.b-dropdown');
            }
        );
    }

};

bHeadUser.getApiUrl = function(){ return '//center.yandex-team.ru/services?callback=?' };

bHeadUser.getUserItems = function(){
    return ['<li class="b-dropdown__item b-dropdown__line">',
            '<a href="//staff.yandex-team.ru/', Lego.params.login, '">',
                Lego.message('b-head-userinfo.user:passport', 'Личные данные'),
            '</a>',
        '</li>'].join('');
};

bHeadUser.getUserLogin = function(data){
    return data.login || Lego.params.login;
};

})(jQuery, window.Lego);
