<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:lego="https://lego.yandex-team.ru"
    exclude-result-prefixes=" x lego "
    version="1.0">

<xsl:template match="lego:b-user-list">
    <div>
        <xsl:apply-templates select="." mode="lego:block-attributes"/>
        <xsl:apply-templates select="." mode="lego:js-params"/>
        <xsl:apply-templates select="lego:title" mode="lego:title"/>
        <xsl:apply-templates select="lego:edit" mode="lego:addfield"/>
        <xsl:apply-templates select="." mode="lego:content"/>
    </div>
</xsl:template>

<xsl:template match="lego:b-user-list" mode="lego:block-class-js">
    <xsl:text> g-js</xsl:text>
</xsl:template>

<xsl:template match="lego:b-user-list" mode="lego:js-params-content">
    <xsl:text>name:</xsl:text><xsl:value-of select="x:js-quote(lego:name(.))"/>
    <xsl:if test="lego:edit">
        <xsl:text>, edit:true</xsl:text>
    </xsl:if>
    <xsl:if test="lego:edit/@ajaxhandler!=''">
        <xsl:text>, ajaxhandler:</xsl:text>
        <xsl:value-of select="x:js-quote(lego:edit/@ajaxhandler)"/>
    </xsl:if>
    <xsl:if test="lego:edit/@confirmdelete">
        <xsl:text>, confirmdelete: true</xsl:text>
    </xsl:if>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:title" mode="lego:title">
    <div class="b-user-list__title">
        <xsl:value-of select="."/>
    </div>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:edit" mode="lego:addfield">
    <div class="b-user-list__new">
        <label class="b-hint-input g-js">
            <xsl:attribute name="for">
                <xsl:apply-templates select="." mode="lego:auto-id-content"/>
            </xsl:attribute>
            <xsl:attribute name="onclick">
                 <xsl:text>return {name:'b-hint-input'}</xsl:text>
            </xsl:attribute>
            <xsl:text>Выберите сотрудника</xsl:text>
        </label>
        <input class="b-user-list__input">
            <xsl:attribute name="id">
                <xsl:apply-templates select="." mode="lego:auto-id-content"/>
            </xsl:attribute>
            <xsl:if test="@tabindex">
                <xsl:attribute name="tabindex">
                    <xsl:value-of select="@tabindex"/>
                </xsl:attribute>
            </xsl:if>
        </input>
        <xsl:apply-templates select="@ajaxhandler" mode="lego:spin"/>
        <xsl:apply-templates select="." mode="lego:hiddeninput"/>
        <xsl:apply-templates select="." mode="lego:errorblock"/>
    </div>
</xsl:template>

<xsl:template match="@ajaxhandler" mode="lego:spin">
    <img class="b-user-list__spin g-hidden" src="//yandex.st/lego/2.2.3/common/block/b-spin/_size/b-spin_16.gif" align="baseline" alt="Загрузка" />
</xsl:template>

<xsl:template match="lego:edit" mode="lego:hiddeninput">
    <input type="hidden" class="b-user-list__output">
        <xsl:attribute name="value">
            <xsl:apply-templates select="../lego:b-user" mode="lego:output-value"/>
        </xsl:attribute>
        <xsl:attribute name="name">
            <xsl:choose>
                <xsl:when test="@inputname">
                    <xsl:value-of select="@inputname"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:text>output</xsl:text>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:attribute>
    </input>
</xsl:template>

<xsl:template match="lego:edit" mode="lego:errorblock">
    <div class="b-user-list__error"></div>
</xsl:template>

<xsl:template match="lego:b-user" mode="lego:output-value">
    <xsl:value-of select="@card"/>
    <xsl:text> </xsl:text>
</xsl:template>

<!-- ############################################################################################################## -->

<xsl:template match="lego:b-user-list" mode="lego:content">
    <ul class="b-user-list__list">
        <xsl:apply-templates select="lego:edit" mode="lego:sample"/>
        <xsl:for-each select="lego:b-user">
            <li>
                <xsl:apply-templates select="../lego:edit" mode="lego:delete"/>
                <xsl:apply-templates select="."/>
            </li>
        </xsl:for-each>
    </ul>
</xsl:template>

<xsl:template match="lego:edit" mode="lego:sample">
    <li class="b-user-list__sample g-hidden">
        <xsl:apply-templates select="." mode="lego:delete"/>
        <xsl:call-template name="lego:apply">
              <xsl:with-param name="content">
                  <lego:b-user card="sample">sample</lego:b-user>
              </xsl:with-param>
        </xsl:call-template>
    </li>
</xsl:template>

<xsl:template match="lego:edit" mode="lego:delete">
    <img src="//center.yandex-team.ru/media/lego/service/intranet/block/b-user-list/b-user-list.del.png" class="b-user-list__del" alt="Удалить" />
</xsl:template>

</xsl:stylesheet>