<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:lego="https://lego.yandex-team.ru"
    exclude-result-prefixes=" x lego "
    version="1.0">

<!-- ############################################################################################################## -->
<!-- подключение xml из Лего для шапок и подвала -->
    
<xsl:variable name="legoxml" select="document(concat('../../../',$lego:id,'/',$lego:id,'.xml'))/lego:page" />

<xsl:template match="/root">
    <html lang="ru">
        <xsl:apply-templates />
    </html>
</xsl:template>

<!-- На отдельны страницах можно менять шапку добавляя атр lego:type, xml пишется в raw-файле с тем же значением -->
<xsl:template match="/root/lego:l-head">
    <xsl:choose>
        <xsl:when test="@lego:type!=''">
            <xsl:apply-templates select="$legoxml/lego:l-head[@lego:type=current()/@lego:type]"/>
        </xsl:when>
        <xsl:otherwise>
            <xsl:apply-templates select="$legoxml/lego:l-head[not(@lego:type)]"/>    
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template match="/root/lego:b-foot">
    <xsl:apply-templates select="$legoxml/lego:b-foot"/>
</xsl:template>

<xsl:template match="lego:params" />

<xsl:template match="/" mode="lego:params">
    <xsl:copy-of select="root/lego:params/*"/>
</xsl:template>

<!-- ############################################################################################################## -->
<!-- Шаблон для автоматического подключения статики -->
    
<xsl:template match="lego:init">
    <xsl:apply-templates select="/" mode="lego:init"/>
</xsl:template>

<xsl:template match="/" mode="lego:favicon">
    <link rel="shortcut icon" href="{$lego:params/lego:static-host}/favicon.ico"/>
</xsl:template>

</xsl:stylesheet>