# coding: utf-8

from setuptools import setup, find_packages, Command


class run_audit(Command):
    """Audits source code using PyFlakes for following issues:
        - Names which are used but not defined or used before they are defined.
        - Names which are redefined without having been used.
        (by mitsuhiko's flask/setup.py)
    """
    description = "Audit source code with PyFlakes"
    user_options = []

    def initialize_options(self):
        pass

    def finalize_options(self):
        pass

    def run(self):
        import os
        import sys
        try:
            import pyflakes.scripts.pyflakes as flakes
        except ImportError:
            print("Audit requires PyFlakes installed in your system.")
            sys.exit(-1)

        warns = 0
        # Define top-level directories
        dirs = ('mlcore', )
        for dir in dirs:
            for root, _, files in os.walk(dir):
                for file in files:
                    if file != '__init__.py' and file.endswith('.py'):
                        warns += flakes.checkPath(os.path.join(root, file))
        if warns > 0:
            print("Audit finished with total %d warnings." % warns)
        else:
            print("No problems found in sourcecode.")


def version_from_changelog():
    # Вытащим версию из changelog
    # Работает только на дебиане, конечно
    import subprocess
    try:
        p = subprocess.Popen(['dpkg-parsechangelog', ], stdout=subprocess.PIPE)
        output = p.communicate()[0]
        PREFIX = 'Version: '
        for line in output.split('\n'):
            if line.startswith(PREFIX):
                return line[len(PREFIX):]
    except OSError:
        pass
    return 'unknown'


__version__ = version_from_changelog()


setup(
    name='mlcore',
    version=__version__,
    description='Yandex intranet maillists managment service core',
    url='https://ml.yandex-team.ru',
    author='Nikita Zubkov',
    author_email='zubchick@yandex-team.ru',
    maintainer='Sergey Lavrinenko',
    maintainer_email='lavrinenko@yandex-team.ru',
    cmdclass={'audit': run_audit},
    include_package_data=True,
    packages=find_packages('src', exclude=('django_intranet_stuff*',)),
    package_dir={'': 'src'},
)
