# encoding: utf-8

import sys
import os

# --- /usr/lib/yandex/tools-maillists/src/maillists/manage.py

sys.path = ['/etc/yandex/tools-maillists',
            '/usr/lib/yandex/tools-maillists/src',
            '/usr/lib/yandex/tools-maillists/src/maillists',
            '/etc/yandex/tools-maillists/celery/',
        ] + sys.path

os.environ.setdefault("DJANGO_SETTINGS_MODULE", "settings")

from mlcore.utils.getters import get_list
from mlcore.ml.models import Subscribers
from mlcore.interaction.ymail import YmailBackend, YmailError
from mlcore.tasks.operations import subscribe_user
from mlcore.subscribe import subscription_type

def get_subscribers(mname):
    mlist = get_list(mname)
    subs = Subscribers.objects.filter(list=mlist, stype=subscription_type.IMAP)
    count_ml = subs.count()
    yclient = YmailBackend()

    print "count ml = %d\n" % count_ml
    for s in subs:
        answer = yclient.subscriptions(s.user)
        if not mname in [a["fname"] for a in answer]:
            print "%s" % s.user
            context = {}
            try:
                subscribe_user.delay(context, user=s.user,
                       maillist=mlist,
                       type=s.stype,
                       check_rights=False,
                       send_notification=False)
            except YmailError:
                print "YmailError: Fail for <%s>" % s.user

if __name__ == "__main__" :
    get_subscribers('staff')