# -*- coding: utf-8 -*-

from django import forms


class DestinationsField(forms.CharField):
    def __init__(self, *args, **kwargs):
        super(DestinationsField, self).__init__(*args, **kwargs)

    def clean(self, value):
        super(forms.CharField, self).clean(value)
        if not value:
            return []
        splitted = filter(len, (x.strip().lower() for x in value.split(',')))
        if self.required and len(splitted) == 0:
            raise forms.ValidationError(self.error_messages['required'])
        else:
            return splitted


class CreateMaillistAlias(forms.Form):
    email = forms.EmailField(required=True)
    destinations = DestinationsField(required=False)
