# -*- coding: utf-8 -*-

from mlcore.nwsmtp_connect.utils import get_maillist_by_email, normalize_email
from mlcore.interaction.compat import compat_requests_session
from mlcore.ml.models import Subscribers, User
from lxml import etree
import json
import logging


class ResponseException(Exception):
    pass


def check_resp_code(response):
    if response.status_code != 200:
        raise ResponseException("%s from external api" %
                                response.status_code)


def load_text_file(url):
    session = compat_requests_session()
    response = session.get(url)
    check_resp_code(response)
    return response.content


def load_json(url):
    session = compat_requests_session()
    response = session.get(url)
    check_resp_code(response)
    try:
        return json.loads(response.content)
    except ValueError as er:
        logging.error(u'Invalid json from %s: %s', url, er)
    return None


def load_xml(url, token):
    session = compat_requests_session()
    response = session.get(url, headers={'Authorization': 'OAuth {}'.format(token)})
    check_resp_code(response)
    try:
        return etree.fromstring(response.content)
    except etree.XMLSyntaxError as err:
        logging.error(u'Invalid xml from %s:\n%s', url, err)
    return None


def filter_crm_emails(url):
    # перенаправляем на crm-рассылки, существующие в ML
    # письма из exchange-ящиков должны переадресовываться в crm-рассылку, но видимо не нами
    for email in load_text_file(url).split('\n'):
        email = normalize_email(email)
        # если email из ручки crm пришел, а для него у нас нет рассылки, то ничего с ним не делаем
        if email and get_maillist_by_email(email):
            yield email


def filter_crm_users(url, tcrm_email):
    tcrm_subscription_user = User.objects.filter(email=tcrm_email)
    tcrm_subscriptions = Subscribers.objects.filter(user=tcrm_subscription_user)
    tcrm_user_emails = [str(i.list.email) for i in tcrm_subscriptions]
    for email in load_text_file(url).split('\n'):
        if email not in tcrm_user_emails:
            logging.info("New email for subscribe to %s: %s ", tcrm_email, email)
            yield email.strip().lower()
