# coding: utf-8

from django.conf.urls import patterns, url

urlpatterns = patterns(
    'mlcore.apiv2.views',
    url(r'^permissions/check.json$', 'check_rights', name='check_rights'),
    url(r'^permissions/user.json$', 'user_rights', name='user_rights'),
    url(r'^permissions/readonly.json$', 'readonly_maillists', name='readonly'),

    url(r'^subscriptions/user.json$', 'user_subscriptions', name='user_subscriptions'),

    url(r'^operations/create_maillist$', 'create_maillist', name='create_maillist'),

    url(r'^maillist/mailstats.json$', 'maillists_mailstats', name='maillists_mailstats'),
    url(r'^maillist/exists$', 'lists_exists.lists_exists', name='maillist_exists'),

    url(r'^intranet/lastupdate$', 'intranet_lastupdate_info', name='intranet_lastupdate_info'),

    url(r'^virtualdomains.json$', 'get_domains', name='get_domains'),
    url(r'^virtualdomains/add$', 'add_domains', name='add_domains'),

    url(r'^calendar/listinfo$', 'mass_lists_subscribers', name='calendar-listinfo'),

    url(r'^maillists/set_fid$', 'set_fid', name='set_fid'),

    url(r'^maillists/create$', 'create', name='create_list'),
    url(r'^maillists/invalidate$', 'invalidate_cache', name='invalidate_cache'),

    url(r'^permissions/change$', 'change_permission', name='change_permission'),
    url(r'^permissions/owners/(?P<action>(add|delete))$', 'change_administrators', name='change_administrators'),


    url(r'^directory/notify$', 'directory_notify', name='directory_notify'),
)


urlpatterns += patterns('',
   url(r'^delivery/info$', 'mlcore.nwsmtp_connect.views.delivery_info', name='delivery_info'),
)

urlpatterns += patterns(
    '',
    url(r'alias/create$', 'mlcore.aliases.views.add_alias', name='alias_create')
)



"""
# Копия ручек api для таска ML-1325
from django.contrib.auth.decorators import login_required
from django_intranet_stuff.views import user_or_group

urlpatterns += patterns('mlcore.mlapi.views',
   url(r'^lists/by_owner/(?P<login>\S+)/$', 'lists_by_owner'),
   url(r'^lists/external/$', 'external_lists'),
   url(r'^lists/non-project/$', 'non_project_lists'),
   url(r'^lists/info/$', 'lists_info'),
   url(r'^lists/$', 'list_names'),
   url(r'^user_or_group.json$', login_required(user_or_group), name='user_or_group'),
   url(r'^subscribers/info/$', 'subscribers_info', name='subscribers_info'),
)
"""
