# encoding: utf-8
import json
from django import forms

from mlcore.apiv2.views.helpers import maillist_by_email


class MailListFormMixin(forms.Form):
     maillist = forms.CharField()

     def clean_maillist(self):
        email = self.cleaned_data['maillist']

        maillist = maillist_by_email(email)
        if not maillist:
            raise forms.ValidationError('Mail list not found')

        return maillist


class UIDFormMixin(forms.Form):
    uids = forms.CharField()

    def clean_uids(self):
        data = self.cleaned_data['uids']
        data = [r.strip() for r in data.split(',')]

        return data


class JSONField(forms.CharField):
    def to_python(self, value):
        try:
            return json.loads(value)
        except (ValueError, TypeError):
            raise forms.ValidationError('Wrong json format')

