# encoding: utf-8
import json
from django.http import HttpResponse
from django_api_auth.decorators import passport_or_token_auth
from django.views.decorators.http import require_POST

from ya_directory import event_processor
from mlcore.tasks.directory import process_notification


@passport_or_token_auth
@require_POST
def notify(request):
    data = json.loads(request.body)

    if not event_processor.can_process(data):
        return HttpResponse(json.dumps({'status': 'skip', 'description': 'event not supported'}),
                            content_type='application/json')

    process_notification.delay(data)

    return HttpResponse(json.dumps({'status': 'ok'}),
                        content_type='application/json')
